//------------------------------------------------------------------------------
// Copyright 2008 Mentor Graphics Corporation
// All Rights Reserved Worldwide
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.  You may obtain
// a copy of the License at
// 
//        http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
// License for the specific language governing permissions and limitations
// under the License.
//------------------------------------------------------------------------------

`define ovm_comp_task_phase(NAME) \
  virtual task NAME();  \
    super.NAME(); \
    ovm_report_info($psprintf("%m"),`"NAME begin`",OVM_MEDIUM); \
    #1000; \
    ovm_report_info($psprintf("%m"),`"NAME end`",OVM_MEDIUM); \
  endtask

`define ovm_comp_func_phase(NAME) \
  virtual function void NAME();  \
    super.NAME(); \
    ovm_report_info($psprintf("%m"),`"NAME`",OVM_MEDIUM); \
  endfunction


//------------------------------------------------------------------------------
// Class- my_ovm_comp
//
// Implements all the OVM phase callbacks with display statements to show
// when each phase is executed in a combined OVM / ENV environment. In OVM,
// all ovm_components possess phasing capability. This way, environments of
// today can become mere building block for larger environments without code
// rewrites. OVM environments are scalable for greater reuse potential.
//------------------------------------------------------------------------------

class ovm_comp_ext extends ovm_component;

  `ovm_component_utils(ovm_comp_ext)
  
  function new (string name, ovm_component parent=null);
    super.new(name,parent);
    enable_stop_interrupt = 1;
  endfunction

  // Implement each phase native to OVM
  `ovm_comp_func_phase(build)
  `ovm_comp_func_phase(connect)
  `ovm_comp_func_phase(end_of_elaboration)
  `ovm_comp_func_phase(start_of_simulation)
  `ovm_comp_task_phase(run)
  `ovm_comp_func_phase(extract)
  `ovm_comp_func_phase(check)
  `ovm_comp_func_phase(report)

  `ifdef INCLUDE_DEPRECATED
  `ovm_comp_func_phase(post_new)
  `ovm_comp_func_phase(export_connections)
  `ovm_comp_func_phase(import_connections)
  `ovm_comp_func_phase(configure)
  `ovm_comp_func_phase(pre_run)
  `endif

  virtual task stop(string ph_name); 
    ovm_report_info($psprintf("%m"),{get_full_name()," stop  Stopping phase ",ph_name},OVM_NONE);
    #1;
    ovm_report_info($psprintf("%m"),{get_full_name()," stop  Stopped phase ",ph_name},OVM_NONE);
  endtask

endclass

