/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  nor.h -- 

  Original Author: Martin Janssen, Synopsys, Inc., 2002-02-15

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

/* Filename nor.h */
/* This is the interface file for asynchronous process 'nor' */

#include "systemc.h"

SC_MODULE( nor )
{
  SC_HAS_PROCESS( nor );

  sc_in<bool>  a;
  sc_in<bool>  b;
  sc_out<bool> c;

  // Constructor 
  nor( sc_module_name NAME,
       sc_signal<bool>& A,
       sc_signal<bool>& B,
       sc_signal<bool>& C )
  {
    a(A);
	b(B);
	c(C);
    SC_METHOD( entry );
    sensitive << a << b;
  }

  // Process functionality in member function below
  void entry();
};

