/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test vcd tracing for sc_in<T>, sc_out<T> and sc_signal<T>
// for all supported C++ data types as defined in the AMS LRM and 1666 LRM

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_source)
{
  sc_core::sc_out<bool> out_bool;
  sc_core::sc_out<float> out_float;
  sc_core::sc_out<double> out_double;
  sc_core::sc_out<unsigned char> out_uchar;
  sc_core::sc_out<unsigned short> out_ushort;
  sc_core::sc_out<unsigned int> out_uint;
  sc_core::sc_out<unsigned long> out_ulong;
  sc_core::sc_out<char> out_char;
  sc_core::sc_out<short> out_short;
  sc_core::sc_out<int> out_int;
  sc_core::sc_out<long> out_long;

  SC_CTOR(my_source) :
   out_bool("out_bool"),
   out_float("out_float"),
   out_double("out_double"),
   out_uchar("out_uchar"),
   out_ushort("out_ushort"),
   out_uint("out_uint"),
   out_ulong("out_ulong"),
   out_char("out_char"),
   out_short("out_short"),
   out_int("out_int"),
   out_long("out_long")
  {
    SC_THREAD(processing);
  }

  void processing()
  {
    while (true)
    {
      out_bool.write (true);
      out_float.write ( 1.01 );
      out_double.write( 1.1 );
      out_uchar.write( 7 );
      out_ushort.write( 31 );
      out_uint.write( 1023 );
      out_ulong.write( 63 );
      out_char.write( 7 );
      out_short.write( 31 );
      out_int.write( 1023 );
      out_long.write( 63 );
      wait(3.2, sc_core::SC_MS);

      out_bool.write (false);
      out_double.write( 2.2 );
      out_float.write ( 2.02 );
      out_uchar.write( 1 );
      out_ushort.write( 3 );
      out_uint.write( 1024 );
      out_ulong.write( 2048 );
      out_char.write( 1 );
      out_short.write( 3 );
      out_int.write( 1024 );
      out_long.write( 2048 );
      wait(0.8, sc_core::SC_MS);
    }
  }
};

SC_MODULE(my_sink)
{
  sc_core::sc_in<bool> in_bool;
  sc_core::sc_in<float> in_float;
  sc_core::sc_in<double> in_double;
  sc_core::sc_in<unsigned char> in_uchar;
  sc_core::sc_in<unsigned short> in_ushort;
  sc_core::sc_in<unsigned int> in_uint;
  sc_core::sc_in<unsigned long> in_ulong;
  sc_core::sc_in<char> in_char;
  sc_core::sc_in<short> in_short;
  sc_core::sc_in<int> in_int;
  sc_core::sc_in<long> in_long;

  SC_CTOR(my_sink) :
   in_bool("in_bool"),
   in_float("in_float"),
   in_double("in_double"),
   in_uchar("in_uchar"),
   in_ushort("in_ushort"),
   in_uint("in_uint"),
   in_ulong("in_ulong"),
   in_char("in_char"),
   in_short("in_short"),
   in_int("in_int"),
   in_long("in_long")
  { }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<bool> sig_bool;
  sc_core::sc_signal<float> sig_float;
  sc_core::sc_signal<double> sig_double;
  sc_core::sc_signal<unsigned char> sig_uchar;
  sc_core::sc_signal<unsigned short> sig_ushort;
  sc_core::sc_signal<unsigned int> sig_uint;
  sc_core::sc_signal<unsigned long> sig_ulong;
  sc_core::sc_signal<char> sig_char;
  sc_core::sc_signal<short> sig_short;
  sc_core::sc_signal<int> sig_int;
  sc_core::sc_signal<long> sig_long;

  my_source src("src");
    src.out_bool( sig_bool );
    src.out_float( sig_float );
    src.out_double( sig_double );
    src.out_uchar( sig_uchar );
    src.out_ushort( sig_ushort );
    src.out_uint( sig_uint );
    src.out_ulong(sig_ulong );
    src.out_char( sig_char );
    src.out_short( sig_short );
    src.out_int( sig_int );
    src.out_long( sig_long );

  my_sink sink("sink");
    sink.in_bool( sig_bool );
    sink.in_float( sig_float );
    sink.in_double( sig_double );
    sink.in_uchar( sig_uchar );
    sink.in_ushort( sig_ushort );
    sink.in_uint( sig_uint );
    sink.in_ulong( sig_ulong );
    sink.in_char( sig_char );
    sink.in_short( sig_short );
    sink.in_int( sig_int );
    sink.in_long( sig_long );

  sca_util::sca_trace_file* tf = sca_util::sca_create_vcd_trace_file("test01");

  sca_util::sca_trace(tf, sig_bool, "sig_bool");
  sca_util::sca_trace(tf, sig_float, "sig_float");
  sca_util::sca_trace(tf, sig_double, "sig_double");
  sca_util::sca_trace(tf, sig_uchar, "sig_uchar");
  sca_util::sca_trace(tf, sig_ushort, "sig_ushort");
  sca_util::sca_trace(tf, sig_uint, "sig_uint");
  sca_util::sca_trace(tf, sig_ulong, "sig_ulong");
  sca_util::sca_trace(tf, sig_char, "sig_char");
  sca_util::sca_trace(tf, sig_short, "sig_short");
  sca_util::sca_trace(tf, sig_int, "sig_int");
  sca_util::sca_trace(tf, sig_long, "sig_long");

  sca_util::sca_trace(tf, src.out_bool, "src.out_bool");
  sca_util::sca_trace(tf, src.out_float, "src.out_float");
  sca_util::sca_trace(tf, src.out_double, "src.out_double");
  sca_util::sca_trace(tf, src.out_uchar, "src.out_uchar");
  sca_util::sca_trace(tf, src.out_ushort, "src.out_ushort");
  sca_util::sca_trace(tf, src.out_uint, "src.out_uint");
  sca_util::sca_trace(tf, src.out_ulong, "src.out_ulong");
  sca_util::sca_trace(tf, src.out_char, "src.out_char");
  sca_util::sca_trace(tf, src.out_short, "src.out_short");
  sca_util::sca_trace(tf, src.out_int, "src.out_int");
  sca_util::sca_trace(tf, src.out_long, "src.out_long");

  sca_util::sca_trace(tf, sink.in_bool, "sink.in_bool");
  sca_util::sca_trace(tf, sink.in_float, "sink.in_float");
  sca_util::sca_trace(tf, sink.in_double, "sink.in_double");
  sca_util::sca_trace(tf, sink.in_uchar, "sink.in_uchar");
  sca_util::sca_trace(tf, sink.in_ushort, "sink.in_ushort");
  sca_util::sca_trace(tf, sink.in_uint, "sink.in_uint");
  sca_util::sca_trace(tf, sink.in_ulong, "sink.in_ulong");
  sca_util::sca_trace(tf, sink.in_char, "sink.in_char");
  sca_util::sca_trace(tf, sink.in_short, "sink.in_short");
  sca_util::sca_trace(tf, sink.in_int, "sink.in_int");
  sca_util::sca_trace(tf, sink.in_long, "sink.in_long");

  // for reference, we also make a VCD file using the core SystemC lib...

  sc_core::sc_trace_file* tf2 = sc_core::sc_create_vcd_trace_file("test01_systemc");

  sc_core::sc_trace(tf2, sig_bool, "sig_bool");
  sc_core::sc_trace(tf2, sig_float, "sig_float");
  sc_core::sc_trace(tf2, sig_double, "sig_double");
  sc_core::sc_trace(tf2, sig_uchar, "sig_uchar");
  sc_core::sc_trace(tf2, sig_ushort, "sig_ushort");
  sc_core::sc_trace(tf2, sig_uint, "sig_uint");
  sc_core::sc_trace(tf2, sig_ulong, "sig_ulong");
  sc_core::sc_trace(tf2, sig_char, "sig_char");
  sc_core::sc_trace(tf2, sig_short, "sig_short");
  sc_core::sc_trace(tf2, sig_int, "sig_int");
  sc_core::sc_trace(tf2, sig_long, "sig_long");

  sc_core::sc_trace(tf2, src.out_bool, "src.out_bool");
  sc_core::sc_trace(tf2, src.out_float, "src.out_float");
  sc_core::sc_trace(tf2, src.out_double, "src.out_double");
  sc_core::sc_trace(tf2, src.out_uchar, "src.out_uchar");
  sc_core::sc_trace(tf2, src.out_ushort, "src.out_ushort");
  sc_core::sc_trace(tf2, src.out_uint, "src.out_uint");
  sc_core::sc_trace(tf2, src.out_ulong, "src.out_ulong");
  sc_core::sc_trace(tf2, src.out_char, "src.out_char");
  sc_core::sc_trace(tf2, src.out_short, "src.out_short");
  sc_core::sc_trace(tf2, src.out_int, "src.out_int");
  sc_core::sc_trace(tf2, src.out_long, "src.out_long");

  sc_core::sc_trace(tf2, sink.in_bool, "sink.in_bool");
  sc_core::sc_trace(tf2, sink.in_float, "sink.in_float");
  sc_core::sc_trace(tf2, sink.in_double, "sink.in_double");
  sc_core::sc_trace(tf2, sink.in_uchar, "sink.in_uchar");
  sc_core::sc_trace(tf2, sink.in_ushort, "sink.in_ushort");
  sc_core::sc_trace(tf2, sink.in_uint, "sink.in_uint");
  sc_core::sc_trace(tf2, sink.in_ulong, "sink.in_ulong");
  sc_core::sc_trace(tf2, sink.in_char, "sink.in_char");
  sc_core::sc_trace(tf2, sink.in_short, "sink.in_short");
  sc_core::sc_trace(tf2, sink.in_int, "sink.in_int");
  sc_core::sc_trace(tf2, sink.in_long, "sink.in_long");

  sc_core::sc_start(10, sc_core::SC_MS);

  sca_util::sca_close_vcd_trace_file(tf);
  sc_core::sc_close_vcd_trace_file(tf2);

  TEST_LABEL_END;

  return 0;
}
