/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// throw error when there is no timestep defined

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  // timestep not defined
  SCA_CTOR( mod_a ) {}
};


int sc_main( int argn, char*[] )
{
  TEST_LABEL_START;

  if (argn == 1)
    sc_core::sc_report_handler::set_handler(test_util::report_handler);

  mod_a a("a");

  sc_core::sc_start(1.0, sc_core::SC_MS);

  TEST_LABEL_END_WITHOUT_ERROR;

  return 0;
}
