/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_core::sca_port<sc_core::sc_signal_in_if<T> > 
// can be bound to sca_tdf::sca_de::sca_in<sc_dt::sc_logic>

#include <systemc-ams>
#include "test_utilities.h"

#define WRITE(a) \
  std::cout << a.name() << " (" << a.kind() << ")" << std::endl

template <class T>    
class my_port : public sca_core::sca_port< sc_core::sc_signal_in_if<T> >
{};

SCA_TDF_MODULE( mod_a )
{
  my_port<sc_dt::sc_logic> in_a;

  SCA_CTOR( mod_a )
  {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_de::sca_in<sc_dt::sc_logic> in_b;
  
  SCA_CTOR( mod_b ) : in_b("in_b")
  {}
};

SC_MODULE( mod_t )
{
  mod_a a;
  mod_b b;

  SC_CTOR( mod_t )
    : a("a"), b("b")
  {
    a.in_a(b.in_b);  // actual binding test here
  }
};


int sc_main( int, char*[] )
{
  TEST_LABEL_START;
  
  mod_t t("t");

  WRITE(t.b.in_b);
  
  TEST_LABEL_END;
    
  return 0;
}
