/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_tdf::sca_de::sca_in member function set_delay() and get_delay()
// with delay set to 2, which should result in 1 timestep delay due to DE/TDF sync.

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( mod_a )
{
  sc_core::sc_out<int> out;

  int val;

  void gen_triangle()
  {
    while (true)
    {
      if (val == max) step = -1;
      if (val == -max) step = 1;

      val = val + step;
      out.write(val);

      wait(sc_core::sc_time(1, sc_core::SC_MS));
    }
  }

  SC_CTOR( mod_a ) : out("out"), val(2), step(1), max(3)
  {
    out.initialize(val);
    SC_THREAD( gen_triangle );
  }

 private:
  int step, max;
};


SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_de::sca_in<int> in;
  sca_tdf::sca_out<int> out;

  void set_attributes()
  {
    in.set_delay(in_delay);
  }

  void initialize()
  {
    for (int i = 0; i < in_delay; i++)
    {
      in.initialize(i + 80, i);
    }
    std::cout << "in.set_delay() set to: " << in_delay << std::endl;
    std::cout << "in.get_delay(): " << in.get_delay() << std::endl;
    std::cout << "in.get_timestep(): " << in.get_timestep() << std::endl;
  }

  void processing()
  {
    val = in.read();
    out.write(val);
  }

  SCA_CTOR( mod_b ) : in("in"), out("out"), in_delay(2), val(0)
  {
  }

 private:
  int in_delay;
  int val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<int> tdf_sig;
  sc_core::sc_signal<int> sc_sig1;

  mod_a a("a");
    a.out(sc_sig1);

  mod_b b("b");
    b.in(sc_sig1);
    b.out(tdf_sig);
    b.set_timestep(1.0, sc_core::SC_MS);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test05");

  sca_util::sca_trace(atf, sc_sig1, "sc_sig1");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  
  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test05", 2);
  
  TEST_LABEL_END;

  return 0;
}
