/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_rate() and get_rate()
// of ports of class sca_tdf::sca_in and sca_tdf:;sca_out

#include <systemc-ams>
#include "test_utilities.h"

test_util::sorted_stream sstr;

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    out.set_rate(rate);
    out.set_timestep(1, sc_core::SC_MS);
  }

  void initialize()
  {
    sstr.redirect_cout(this->get_time(), 11);

    std::cout << "out.kind() : " << out.kind() << std::endl;
    std::cout << "out.name() : " << out.name() << std::endl;
    std::cout << "out.get_rate() : " << out.get_rate() << std::endl;

    sstr.restore_cout();
  }

  void processing()
  {
    sstr.redirect_cout(this->get_time(), 31);

    std::cout << "------- A -------" << std::endl;
    for (int i = 0; i < rate; i++)
    {
      out.write(val, i);
      std::cout << "out: " << out.get_time(i) << "\t" << val << std::endl;
      val++;
    }

    sstr.restore_cout();
  }

  SCA_CTOR( mod_a ) : out("out"), rate(3), val(10.0)
  {
  }

 private:
  int rate;
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    in.set_rate(rate);
  }

  void initialize()
  {
    sstr.redirect_cout(this->get_time(), 12);

    std::cout << "in.kind() : " << in.kind() << std::endl;
    std::cout << "in.name() : " << in.name() << std::endl;
    std::cout << "in.get_rate() : " << in.get_rate() << std::endl;
    std::cout << "-----------------" << std::endl;

    sstr.restore_cout();
  }

  void processing()
  {
    sstr.redirect_cout(this->get_time(), 32);

    std::cout << "------- B -------" << std::endl;

    for (int i = 0; i < rate; i++)
    {
      std::cout << "in:  " << in.get_time(i) << "\t" << in.read(i) << std::endl;
    }

    sstr.restore_cout();
  }

  SCA_CTOR( mod_b ) : in("in"), rate(2)
  {
  }

 private:
  int rate;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a("a");
    a.out(sig);

  mod_b b("b");
    b.in(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  sstr.print();

  TEST_LABEL_END;

  return 0;
}
