/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test multiplexing of primitive sca_lsf::sca_tdf::sca_mux

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(step)
{
  sca_tdf::sca_out<bool> out; // output port

  SCA_CTOR(step) : out("out")
  {}

  void set_attributes()
  {
    out.set_delay(2);
  }

  void initialize()
  {
    out.initialize(false, 0);
    out.initialize(false, 1);
  }

  void processing()
  {
    out.write(true);
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source source1("source1");
  sca_lsf::sca_source source2("source2");
  sca_lsf::sca_tdf::sca_mux mux("mux");
  step step("step");
  
  sca_lsf::sca_signal lsf_sig1, lsf_sig2, lsf_sig3;
  sca_tdf::sca_signal<bool> tdf_sig;

  source1.y(lsf_sig1);
  source1.offset = 1.1;

  source2.y(lsf_sig2);
  source2.offset = 2.2;

  step.out(tdf_sig);
  
  mux.x1(lsf_sig1);
  mux.x2(lsf_sig2);
  mux.y(lsf_sig3);
  mux.ctrl(tdf_sig);
  mux.set_timestep(1.0, sc_core::SC_SEC);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test03");

  sca_util::sca_trace(atf, lsf_sig1, "lsf_sig1");
  sca_util::sca_trace(atf, lsf_sig2, "lsf_sig2");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  sca_util::sca_trace(atf, lsf_sig3, "lsf_sig3");

  sc_core::sc_start(5.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test03", 4);

  TEST_LABEL_END;

  return 0;
}
