/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_lsf::sca_tdf::sca_mux is derived from sca_lsf::sca_module

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_tdf::sca_mux* my_mux;
  my_mux = new sca_lsf::sca_tdf::sca_mux("my_mux");
  sca_lsf::sca_module* obj = my_mux;

  if (obj)
  {
    std::cout << "object valid: " << obj->kind() << std::endl;
    std::cout << "object name: " << obj->name() << std::endl;
  }

  sca_lsf::sca_tdf_mux* my_mux2;
  my_mux2 = new sca_lsf::sca_tdf_mux("my_mux2");
  sca_lsf::sca_module* obj2 = my_mux2;

  if (obj2)
  {
    std::cout << "object valid: " << obj2->kind() << std::endl;
    std::cout << "object name: " << obj2->name() << std::endl;
  }
  
  TEST_LABEL_END;

  delete my_mux, my_mux2;
  
  return 0;
}
