/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test kind() function and constructor arguments of sca_lsf::sca_source

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source source("source");

  std::cout << "source.kind(): " << source.kind() << std::endl;

  std::cout << "source.y.kind(): " << source.y.kind() << std::endl;
  std::cout << "source.y.name(): " << source.y.name() << std::endl;

  std::cout << "source.init_value.kind(): " << source.init_value.kind() << std::endl;
  std::cout << "source.init_value.name(): " << source.init_value.name() << std::endl;
  std::cout << "value source.init_value: " << source.init_value << std::endl;

  std::cout << "source.offset.kind(): " << source.offset.kind() << std::endl;
  std::cout << "source.offset.name(): " << source.offset.name() << std::endl;
  std::cout << "value source.offset: " << source.offset << std::endl;

  std::cout << "source.amplitude.kind(): " << source.amplitude.kind() << std::endl;
  std::cout << "source.amplitude.name(): " << source.amplitude.name() << std::endl;
  std::cout << "value source.amplitude: " << source.amplitude << std::endl;

  std::cout << "source.frequency.kind(): " << source.frequency.kind() << std::endl;
  std::cout << "source.frequency.name(): " << source.frequency.name() << std::endl;
  std::cout << "value source.frequency: " << source.frequency << std::endl;

  std::cout << "source.phase.kind(): " << source.phase.kind() << std::endl;
  std::cout << "source.phase.name(): " << source.phase.name() << std::endl;
  std::cout << "value source.phase: " << source.phase << std::endl;

  std::cout << "source.delay.kind(): " << source.delay.kind() << std::endl;
  std::cout << "source.delay.name(): " << source.delay.name() << std::endl;
  std::cout << "value source.delay: " << source.delay << std::endl;

  std::cout << "source.ac_amplitude.kind(): " << source.ac_amplitude.kind() << std::endl;
  std::cout << "source.ac_amplitude.name(): " << source.ac_amplitude.name() << std::endl;
  std::cout << "value source.ac_amplitude: " << source.ac_amplitude << std::endl;

  std::cout << "source.ac_phase.kind(): " << source.ac_phase.kind() << std::endl;
  std::cout << "source.ac_phase.name(): " << source.ac_phase.name() << std::endl;
  std::cout << "value source.ac_phase: " << source.ac_phase << std::endl;

  std::cout << "source.ac_noise_amplitude.kind(): " << source.ac_noise_amplitude.kind() << std::endl;
  std::cout << "source.ac_noise_amplitude.name(): " << source.ac_noise_amplitude.name() << std::endl;
  std::cout << "value source.ac_noise_amplitude: " << source.ac_noise_amplitude << std::endl;

  TEST_LABEL_END;

  return 0;
}
