/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_lsf::sca_out is derived from sca_core::sca_port<sca_lsf::sca_signal_if>

#include <systemc-ams>
#include "test_utilities.h"

class my_port : public sca_lsf::sca_out
{};

SC_MODULE( mod_a )
{
  typedef sca_core::sca_port<sca_lsf::sca_signal_if > port_base;

  SC_CTOR( mod_a )
  {
    my_port1 = new my_port();
    port_base* obj = dynamic_cast< port_base* >(my_port1);
  }

  ~mod_a()
  {
    delete my_port1;
  }
  
 private:
  my_port* my_port1;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  TEST_LABEL_END;

  return 0;
}
