/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test if sca_lsf::sca_module is derived from sca_core::sca_module
// test kind() of sca_lsf::sca_module 

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_gain* gain1 = new sca_lsf::sca_gain("gain1");

  sca_lsf::sca_module* mod1 = dynamic_cast< sca_lsf::sca_module*>(gain1);

  if (mod1 == NULL)
  {
    std::cout << "LSF primitive not derived from sca_lsf::sca_module" << std::endl;
    return 1;  
  }

  std::cout << "kind of mod1: ";
  std::cout << mod1->sca_lsf::sca_module::kind() << std::endl;

  sca_core::sca_module* mod2 = dynamic_cast< sca_core::sca_module*>(mod1);

  if (mod2 == NULL)
  {
    std::cout << "sca_lsf::sca_module not derived from sca_core::sca_module" << std::endl;
    return 1;  
  }

  std::cout << "kind of mod2: ";
  std::cout << mod2->sca_core::sca_module::kind() << std::endl;

  TEST_LABEL_END;

  delete gain1;
  
  return 0;
}
