/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(top)
{
  sca_eln::sca_vsource vs;
  sca_eln::sca_r r1;
  sca_eln::sca_r r2;
  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node_ref gnd;

  SC_CTOR(top):
    vs("vs", 5.0, 5.0, 2.0, 5e4, 0.0)
  , r1("r1", 1000)
  , r2("r2", 400)
  , n1("n1")
  , n2("n2")
  , gnd("gnd")
  {
    std::cout << "construction of " << this->name() << std::endl;
    std::cout << "DEBUG - name of vs  = " << vs.name() << std::endl;
    std::cout << "DEBUG - name of n1  = " << n1.name() << std::endl;
    std::cout << "DEBUG - name of n2  = " << n2.name() << std::endl;
    std::cout << "DEBUG - name of gnd = " << gnd.name() << std::endl;
    vs.set_timestep(1, sc_core::SC_NS);
    vs.p(n1);
    vs.n(gnd);
    r1.p(n1);
    r1.n(n2);
    r2.p(n2);
    r2.n(gnd);
  }
};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  top TOP("TOP");

  sc_core::sc_start(1.0, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
