/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

 // test inductor based on step response

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(circuit)
{  
  sca_eln::sca_node n_in;
  sca_eln::sca_node n_out;
  sca_eln::sca_node_ref n_gnd;   // reference node
      
  sca_eln::sca_vsource *src;
  sca_eln::sca_l *ind;
  sca_eln::sca_r *res;

  SC_CTOR( circuit )
  : n_in("n_in"), n_out("n_out"), n_gnd("n_gnd")
  {
    src = new sca_eln::sca_vsource("src");
    src->offset = 1.0;
    src->p(n_in);
    src->n(n_gnd);

    res = new sca_eln::sca_r("res");
    res->p(n_in);
    res->n(n_out);
    res->value = 1;

    ind = new sca_eln::sca_l("ind");
    ind->p(n_out);
    ind->n(n_gnd);
    ind->value = 1;
    
    ind->set_timestep(0.1, sc_core::SC_SEC);
  }

  ~circuit()
  {
    delete src, res, ind;
  }
};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  circuit* cir = new circuit ("circuit");

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("test03");
    
  sca_util::sca_trace(tf, cir->n_in, "n_in");
  sca_util::sca_trace(tf, cir->n_out, "n_out");
   
  sc_core::sc_start(5, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(tf);

  test_util::check_results("test03", 2);

  TEST_LABEL_END;

  delete cir;
  
  return 0;
}
