/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_tdf::sca_out<T, sca_tdf::SCA_NO_CUT> member function set_timestep(t)
// and using operator= for port read and write

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double, sca_tdf::SCA_NO_CUT> out;

  void set_attributes()
  {
    sca_core::sca_time t(1.0, sc_core::SC_MS);
    out.set_timestep(t);
  }

  void initialize()
  {
    std::cout << "out.name() : " << out.name() << std::endl;
    std::cout << "out.kind() : " << out.kind() << std::endl;
    std::cout << "out.get_timestep() : " << out.get_timestep() << std::endl;
  }

  void processing()
  {
    std::cout << out.get_time() << "\t" << val << std::endl;
    out = val;
    val++;
  }

  SCA_CTOR( mod_a ) : out("out"), val(3.0)
  {
  }

private:
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    sca_core::sca_time t(1.0, sc_core::SC_MS);
    in.set_timestep(t);
  }

  void processing()
  {
  }

  SCA_CTOR( mod_b) : in("in")
  {
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a("a");
    a.out(sig);

  mod_b b("b");
    b.in(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
