/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_rate() and get_rate()
// of ports of class sca_tdf::sca_in and sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double, sca_tdf::SCA_CT_CUT, sca_tdf::sca_default_interpolator<double> > out;

  void set_attributes()
  {
    out.set_rate(rate);
    out.set_timestep(1, sc_core::SC_MS);
    out.set_delay(1); // mandatory for CT decoupling port
  }

  void initialize()
  {
    out.initialize(0.0, 0);
    std::cout << name() << " out.kind(): " << out.kind() << std::endl;
    std::cout << name() << " out.name(): " << out.name() << std::endl;
    std::cout << name() << " out.get_rate(): " << out.get_rate() << std::endl << std::endl;
  }

  void processing()
  {
    for (int i = 0; i < rate; i++)
    {
      out.write(val, i);
      std::cout << name() << " out.get_time(): " << out.get_time(i) << " value: " << val << std::endl;
      val++;
    }
    std::cout << std::endl;
  }

  SCA_CTOR( mod_a ) : out("out"), rate(1), val(10.0)
  {
  }

 private:
  int rate;
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    in.set_rate(rate);
    in.set_timestep(1, sc_core::SC_MS);
  }

  void initialize()
  {
    std::cout << std::setw(50) << name() << " in.kind(): " << in.kind() << std::endl;
    std::cout << std::setw(50) << name() << " in.name(): " << in.name() << std::endl;
    std::cout << std::setw(50) << name() << " in.get_rate(): " << in.get_rate() << std::endl << std::endl;
  }

  void processing()
  {
    for (int i = 0; i < rate; i++)
    {
        val = in.read(i);
        std::cout << std::setw(50) << name() << " in.get_time(): " << in.get_time(i) << " value: " << val << std::endl;
        val++;
    }
  }

  SCA_CTOR( mod_b ) : in("in"), rate(1)
  {
  }

 private:
  int rate;
  double val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a("mod_a");
    a.out(sig);

  mod_b b("mod_b");
    b.in(sig);

  sca_util::sca_trace_file* tf1 = sca_util::sca_create_tabular_trace_file("test03");
  sca_util::sca_trace(tf1, sig, "sig");

  sca_util::sca_trace_file* tf2 = sca_util::sca_create_vcd_trace_file("test03");
  sca_util::sca_trace(tf2, sig, "sig");

  sc_core::sc_start(10, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(tf1);
  sca_util::sca_close_vcd_trace_file(tf2);

  test_util::check_results("test03", 1);

  TEST_LABEL_END;

  return 0;
}
