/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test if sca_core::sca_port<sc_core::sc_signal_in_if<T> > 
// can be bound to sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>

#include <systemc-ams>
#include "test_utilities.h"

#define WRITE(a) \
  std::cout << a.name() << " (" << a.kind() << ")" << std::endl

template <class T>
class my_port : public sca_core::sca_port< sca_tdf::sca_signal_if<T> >
{};

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out_a;

  SCA_CTOR( mod_a ) : out_a("out_a")
  {}
};

SC_MODULE( mod_t )
{
  sca_tdf::sca_out<double, sca_tdf::SCA_CT_CUT> out_t;

  mod_a a;

  SC_CTOR( mod_t ) : a("a"), out_t("out_t")
  {
    a.out_a(out_t);  // actual binding test here
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;
  
  mod_t t("t");

  WRITE(t.out_t);

  TEST_LABEL_END;
    
  return 0;
}
