/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>
// is derived from sca_core::sca_port<sca_tdf::sca_signal_if>

#include <systemc-ams>
#include "test_utilities.h"

template <class T>
struct my_port : public sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>
{
  explicit my_port(const char* nm) : sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>(nm)
  {}
};

SCA_TDF_MODULE( mod_a )
{
  SCA_CTOR( mod_a )
  {
    sca_core::sca_port< sca_tdf::sca_signal_if<double> >* my_port1 =
      new my_port<double>("my_port");

    sca_tdf::sca_out_base<double>* my_port2 =
      new my_port<double>("my_port2");

    std::cout << "my_port1.kind(): " << my_port1->kind() << std::endl;
    std::cout << "my_port2.kind(): " << my_port2->kind() << std::endl;

  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  TEST_LABEL_END;

  return 0;
}
