/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test TDF module processing using set_timestep() and get_timestep
// for SystemC AMS 2.0

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( tdf_module )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep( 1.0, sc_core::SC_MS );
    does_attribute_changes(); // enable dynamic TDF
  }

  void initialize()
  {
    std::cout << "initialize     @" << get_time() << ": is_dynamic?: " << (is_dynamic() ? "yes" : "no") << std::endl;
    std::cout << "initialize     @" << get_time() << ": are_attribute_changes_allowed?: " << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
    std::cout << "initialize     @" << get_time() << ": module timestep = " << get_timestep() << std::endl;

    std::string last_timestep_string;
    if ( get_last_timestep() == sca_core::sca_max_time() )
      last_timestep_string = "sca_core::sca_max_time";
    else last_timestep_string = get_last_timestep().to_string();

    std::cout << "initialize     @" << get_time() << ": module last timestep = " << last_timestep_string << std::endl;
  }

  void reinitialize()
  {
    std::cout << "reinitialize   @" << get_time() << ": module timestep = " << get_timestep() << std::endl;

    std::string last_timestep_string;
    if ( get_last_timestep() == sca_core::sca_max_time() )
      last_timestep_string = "sca_core::sca_max_time";
    else last_timestep_string = get_last_timestep().to_string();

    std::cout << "reinitialize   @" << get_time() << ": module last timestep = " << last_timestep_string << std::endl;
  }

  void processing()
  {
    std::cout << "processing     @" << get_time() << ": is_timestep_changed?: " << (is_timestep_changed() ? "yes" : "no" ) << std::endl;
    std::cout << "processing     @" << get_time() << ": are_attributes_changed?: " << (are_attributes_changed() ? "yes" : "no" ) << std::endl;
    std::cout << "processing     @" << get_time() << ": module timestep = " << get_timestep() << std::endl;

    std::string last_timestep_string;
    if ( get_last_timestep() == sca_core::sca_max_time() )
      last_timestep_string = "sca_core::sca_max_time";
    else last_timestep_string = get_last_timestep().to_string();

    std::cout << "processing     @" << get_time() << ": module last timestep = " << last_timestep_string << std::endl;
  }

  void change_attributes()
  {
    std::cout << "change_attrib  @" << get_time() << ": module timestep = " << get_timestep() << std::endl;

    std::string last_timestep_string;
    if ( get_last_timestep() == sca_core::sca_max_time() )
      last_timestep_string = "sca_core::sca_max_time";
    else last_timestep_string = get_last_timestep().to_string();

    std::cout << "change_attrib  @" << get_time() << ": module last timestep = " << last_timestep_string << std::endl;
    double t = get_time().to_seconds();
    if ( t == 2.0e-3) {
      set_timestep( 2.0, sc_core::SC_MS );
      std::cout << "change_attrib  @" << get_time() << ": ***module timestep changed by user*** to 2ms" << std::endl;
    }
  }

  SCA_CTOR( tdf_module ) : out("out") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  tdf_module mod1("mod1");
  mod1.out(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
