/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test ltf_zp for SystemC-AMS 2.0 dtdf -
// correct integration with variable timesteps

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_in<double> inp;
  sca_tdf::sca_in<double> inp3;

  sca_tdf::sca_ltf_zp ltf1, ltf2, ltf3, ltf4;
  sca_util::sca_vector<double> s1, s3;
  sca_util::sca_vector<sca_util::sca_complex> poles, zeros;

  void set_attributes()
  {
    set_timestep(3.0, sc_core::SC_MS);
    does_attribute_changes();
    inp3.set_rate(3);
  }

  void initialize()
  {
    // H(s) = 1 / s
    poles(0) = 0.0;
  }

  void reinitialize()
  {
  }

  void processing()
  {
    double out1 = ltf1(zeros, poles, inp);
    double out2 = ltf2(zeros, poles, inp);

    if (std::fabs(get_time().to_seconds() - out1) > out1 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out1: " << out1 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    if (std::fabs(get_time().to_seconds() - out2) > out2 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out2: " << out2 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    //////////////////////////////////////////////////////////

    double out3 = ltf3(zeros, poles, s3, inp3);
    double out4 = ltf4(zeros, poles, inp3);

    // we have an absolute time-> value error of the time resolution (1ps)
    // remains constant due its compensated during each module_timestep
    if (std::fabs(get_time().to_seconds() - out3) > out3 / 1e8)
    {
      std::ostringstream str;
      str << "Unexpected result for out3: " << out3 << " at: "
          << get_time().to_seconds() << " sec " << " diff: " << get_time().to_seconds() - out3;
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    if (std::fabs(get_time().to_seconds() - out4)> out4 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out2: " << out4 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }
  }

  void change_attributes()
  {
    switch(cnt)
    {
      case 0:
      case 1:
        break;
      case 2:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 3:
        break;
      case 4:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 5:
        request_next_activation(0.6, sc_core::SC_MS);
        break;
      case 6:
        break;
      case 7:
        set_timestep(0.3, sc_core::SC_MS);
        break;
      case 8:
        break;
      case 9:
        set_timestep(1.3, sc_core::SC_MS);
        break;
      case 10:
        break;
      case 11:
        request_next_activation(1.5, sc_core::SC_MS);
        break;
      case 12:
        break;
      case 13:
        set_max_timestep(0.7, sc_core::SC_MS);
        break;
      case 14:
        break;
      case 15:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 16:
        break;
      case 17:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 18:
        request_next_activation(0.8, sc_core::SC_MS);
        set_max_timestep(1.0, sc_core::SC_MS);
        break;
      default:
        sc_core::sc_stop();
        break;
    }
    cnt++;
  }

  SCA_CTOR( mod_a ) : cnt(0), inp("inp"), inp3("inp3"),
    ltf1("ltf1"), ltf2("ltf2"), ltf3("ltf3"), ltf4("ltf4")
  {}

 private:
  long cnt;
};

SCA_TDF_MODULE(my_step)
{
  sca_tdf::sca_out<double> out; // output port

  SCA_CTOR(my_step) : out("out")
  {}

  void set_attributes()
  {
    out.set_delay(0);
    accept_attribute_changes();
  }

  void initialize()
  {
  }

  void processing()
  {
    out.write(1.0);
  }

  void reinitialize()
  {
  }

  void change_attributes()
  {
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;
  sca_tdf::sca_signal<double> sig3;

  my_step step("step");
  step.out(sig1);

  my_step step3("step3");
  step3.out(sig3);

  mod_a a("a");
  a.inp(sig1);
  a.inp3(sig3);

  sc_core::sc_start();

  TEST_LABEL_END;

  return 0;
}
