/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  test_sca_out_no_cut_to_sca_in.cpp --
//    Connecting sca_tdf::sca_out<T, sca_tdf::SCA_NO_CUT> to sca_tdf::sca_in<T>

#include <systemc-ams>
#include "test_utilities.h"

#include "counter.h"
#include "sink.h"

int sc_main(int argc, char* argv[])
{
  using sca_core::sca_time;

  TEST_LABEL_START;

  // Time resolution
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_NS);

  // Time step definition
  sca_time dt = sca_time(1.0, sc_core::SC_SEC);
  
  // Simulation stop time
  sc_core::sc_time tstop(25.0, sc_core::SC_SEC);

  // Variables and Signals
  double init_count = 0.0;
  sca_tdf::sca_signal<double> sig_source;

  // Module instantiation
  counter<double, sca_tdf::SCA_NO_CUT> counter_1("counter_1", init_count, dt);
  counter_1.out(sig_source);

  sink<double> sink_1("sink_1", dt);
  sink_1.in(sig_source);

  // Simulation
  try
  {
    sc_core::sc_start(tstop);
  }
  catch (const std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  TEST_LABEL_END;

  sc_core::sc_stop();

  return sc_core::sc_report_handler::get_count(sc_core::SC_ERROR);
}

// vim: expandtab : tabstop=2 : softtabstop=2 : shiftwidth=2
