/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// my_structural example from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_in<double> in2;
  sca_tdf::sca_out<double> out;

  SCA_CTOR( mod_a ) : in1("in1"), in2("in2"), out("out") {}

  void processing() {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  SCA_CTOR( mod_b ) : in("in"), out("out") {}

  void set_attributes()
  {
    in.set_delay(1);
  }

  void processing() {}
};

SCA_TDF_MODULE( mod_x )
{
  sca_tdf::sca_out<double> out;

  SCA_CTOR( mod_x ) : out("out") {}

  void processing() {}
};

SCA_TDF_MODULE( mod_y )
{
  sca_tdf::sca_in<double> in;

  SCA_CTOR( mod_y ) : in("in") {}

  void set_attributes()
  {
    in.set_timestep(1, sc_core::SC_MS);
  }

  void processing() {}
};

SC_MODULE(my_structural_module)
{

  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  mod_a a;
  mod_b b;

  SC_CTOR(my_structural_module)
  : in("in"), out("out"), a("a"), b("b"), sig("sig")
  {
    a.in1(in);
    a.in2(out);
    a.out(sig);

    b.in(sig);
    b.out(out);
  }

 private:
  sca_tdf::sca_signal<double> sig;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;
  sca_tdf::sca_signal<double> sig2;

  my_structural_module dut("dut");
  mod_x x("x");
  mod_y y("y");

  x.out(sig1);
  dut.in(sig1);
  dut.out(sig2);
  y.in(sig2);

  sc_core::sc_start(3, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
