/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_multi_rate_sink from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_multi_rate_const_source)
{

  // port declaration
  sca_tdf::sca_out<double> out;

  my_multi_rate_const_source(sc_core::sc_module_name, double val_ = 1.0 )
  : out("out"), val( val_ ) {}

  void set_attributes()
  {
    out.set_rate(2); // 2 samples written per module activation
  }

  void processing()
  {
    out.write(val); // Writes val as the first sample to the port out
    out.write(val, 0); // Writes val as the first sample to the port out by specifying the index 0
    out.write(val, 1); // Writes val as the second sample to the port out by specifying the index 1

    std::cout << "value (val) written:" << val << std::endl;

    sca_core::sca_time t;

    t = out.get_time(); // return time of the first sample of port out
    t = out.get_time(0); // same method, the first sample has index #0
  }

 private:
  double val; // value to be written to the port
};

SCA_TDF_MODULE(my_multi_rate_sink)
{
  sca_tdf::sca_in<double> in;

  SCA_CTOR(my_multi_rate_sink) : in("in") {}

  void set_attributes()
  {
    in.set_rate(2); // 2 samples read per module activation
    in.set_timestep(1, sc_core::SC_MS);
  }

  void processing()
  {
    // local variable
    double val; // return value ( should be the same data type as the port type )

    val = in.read(); // read first sample
    val = in.read(0); // same method with index for first sample
    val = in.read(1); // same method with index for second sample

    sca_core::sca_time t;

    t = in.get_time(1); // return time of sample #2 of port in

    std::cout << "value (val) read:" << val << std::endl;
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  my_multi_rate_const_source src("src");
  my_multi_rate_sink sink("sink");

  src.out(sig);
  sink.in(sig);

  sc_core::sc_start(3, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}

