/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// serializer from user's guide

#include <systemc-ams>
#include "test_utilities.h"

#include "bask_mod.h"
#include "bit_src.h"

template <int N>
SCA_TDF_MODULE(serializer)
{        
  sca_tdf::sca_in<sc_dt::sc_bv<N> > in;  // input port
  sca_tdf::sca_out<bool> out;            // output port

  SCA_CTOR(serializer) : in("in"), out("out") {} 

  void set_attributes()
  {
    out.set_rate(N);
  }
        
  void processing()
  { 
    for (int i = 0; i < N; i++)
    {
      out.write( in.read().get_bit(i), i );
    }
  }
};

SC_MODULE(modulator)
{
  sca_tdf::sca_in<sc_dt::sc_bv<3> > in;
  sca_tdf::sca_out<double> out;

  serializer<3> ser;
  bask_mod      mod;

  SC_CTOR(modulator) : in("in"), out("out"), ser("ser"), mod("mod"), bits("bits")
  {
    ser.in(in);
    ser.out(bits);

    mod.in(bits);
    mod.out(out);
  }

 private:
  sca_tdf::sca_signal<bool> bits;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal< sc_dt::sc_bv<3> > sig1;
  sca_tdf::sca_signal<double> sig2;

  bit_src onlyones("onlyones");
    onlyones.out(sig1);
  
  modulator modu("mod");
    modu.in(sig1);
    modu.out(sig2);
    
  sc_core::sc_start(5.0, sc_core::SC_MS);  
  
  TEST_LABEL_END;
    
  return 0;
}
