/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_lsf_source)
{
  // port declaration
  sca_lsf::sca_out y;

  // child module declaration
  sca_lsf::sca_source src;

  SC_CTOR(my_lsf_source)
  : y("y"),
    src("src", 0.0, 0.0, 1.0e-3, 1.0e3) // 1 kHz sinusoidal source with an amplitude of 1e-3
  {
    src.set_timestep(0.5, sc_core::SC_MS); // set module timestep of source to 0.5 ms
    src.y(y);
  }
};

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);
    
  TEST_LABEL_START;

  sca_lsf::sca_signal s;
  
  my_lsf_source src("src"); 
    src.y(s);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("my_lsf_source");
  sca_util::sca_trace(tf, s, "s");

  sc_core::sc_start(2, sc_core::SC_MS);
  
  sca_util::sca_close_tabular_trace_file(tf);
  
  test_util::check_results("my_lsf_source", 1, 1e-18);

  TEST_LABEL_END;
  
  return 0;
}
