/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(ltf_nd_filter)
{
  sca_lsf::sca_in x;
  sca_lsf::sca_out y;
    
  ltf_nd_filter( sc_core::sc_module_name nm )
  : x("x"), y("y")
  {
    num(0) = 1.0;   //               1
    den(0) = 20.0;  //  H(s)=  -------------
    den(1) = 10.0;  //          2
    den(2) = 1.0;   //         s  + 10s + 20
  
    ltf1 = new sca_lsf::sca_ltf_nd("ltf1", num, den);
     ltf1->x(x);
     ltf1->y(y);
  }

  ~ltf_nd_filter()
  {
    delete ltf1;
  }
  
 private:
  sca_util::sca_vector<double> num, den; // numerator and denominator coefficients
  sca_lsf::sca_ltf_nd* ltf1;
};

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START;  
  
  sca_lsf::sca_signal in, error, out, pid_out;

  sca_lsf::sca_source src("src", 0.0, 1.0); // step of 1 unit at t=0
    src.y(in);
    src.set_timestep(0.1, sc_core::SC_SEC);

  ltf_nd_filter plant("plant1");
    plant.x(in);
    plant.y(out);
    
  // trace in tabular format to the shell
  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("ltf_step");

  sca_util::sca_trace(atf, in, "in");
  sca_util::sca_trace(atf, out, "out");
    
  sc_core::sc_start(2.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("ltf_step", 2);
  
  TEST_LABEL_END;

  return 0;
}
