/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// user's guide example my_eln_source

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_eln_source)
{
  sca_eln::sca_terminal p;
  
  sca_eln::sca_vsource v_src;
  
  SC_CTOR(my_eln_source) 
  : p("p"),
    v_src("v_src", 0.0, 0.0, 1.0, 1.0e3),  // 1 kHz sinusoidal source with an amplitude of 1 V  
    gnd("gnd")
  {
    v_src.set_timestep(0.125, sc_core::SC_MS); // set module timestep to 0.125 ms
    v_src.p(p);
    v_src.n(gnd);
  }

 private:
  sca_eln::sca_node_ref gnd;
};

SC_MODULE(my_eln_load)
{
  sca_eln::sca_terminal p;
  
  sca_eln::sca_r r1;
  
  SC_CTOR(my_eln_load) : p("p"), 
    r1("r1",  1.0e3), // 1 kOhm
    gnd("gnd") 
  {
    r1.p(p);
    r1.n(gnd);
  }

 private:
  sca_eln::sca_node_ref gnd;

};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_node net1;
  
  my_eln_source src("src");
    src.p(net1);

  my_eln_load load("load");
    load.p(net1);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("my_eln_source");

  sca_util::sca_trace(atf, net1, "net1");
  
  sc_core::sc_start(2.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);
  
  test_util::check_results("my_eln_source", 1, 1e-15);

  TEST_LABEL_END;
    
  return 0;
}
