/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>

SC_MODULE(pi_ctrl)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  pi_ctrl( sc_core::sc_module_name, double kp, double ki)
  : in("in"), out("out"), tdf2lsf("tdf2lsf"), gain1("gain1", kp),
    add1("add1"), integ1("integ1", ki), lsf2tdf("lsf2tdf")
  {
    tdf2lsf.inp(in);
    tdf2lsf.y(sig_ref);

    gain1.x(sig_ref);
    gain1.y(sig_p);

    integ1.x(sig_ref);
    integ1.y(sig_i);

    add1.x1(sig_p);
    add1.x2(sig_i);
    add1.y(sig_pi);

    lsf2tdf.x(sig_pi);
    lsf2tdf.outp(out);
  }

 private:
  sca_lsf::sca_tdf::sca_source tdf2lsf;
  sca_lsf::sca_gain gain1;
  sca_lsf::sca_integ integ1;
  sca_lsf::sca_add add1;
  sca_lsf::sca_tdf::sca_sink lsf2tdf;
  sca_lsf::sca_signal sig_p, sig_i, sig_pi, sig_ref;
};
