/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test copyright, version and release functions

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  std::cout << "--------------------------show version------------------------------" << std::endl;
  std::cout << sca_core::sca_version() << std::endl;
  std::cout << "--------------------------------------------------------------------" << std::endl;

  std::cout << "--------------------------show release------------------------------" << std::endl;
  std::cout << sca_core::sca_release() << std::endl;
  std::cout << "--------------------------------------------------------------------" << std::endl;

  std::cout << "--------------------------show copyright----------------------------" << std::endl;
  std::cout << sca_core::sca_copyright() << std::endl;
  std::cout << "--------------------------------------------------------------------" << std::endl;

  // the content of the strings is implementation dependent

  TEST_LABEL_START;

  if (!std::string(sca_core::sca_version()).empty())
  {
    SC_REPORT_INFO("sc_copyright", "Version string available");
  }

  if (!std::string(sca_core::sca_release()).empty())
  {
    SC_REPORT_INFO("sc_copyright", "Release string available");
  }

  if (!std::string(sca_core::sca_copyright()).empty())
  {
    SC_REPORT_INFO("sc_copyright", "Copyright string available");
  }

  TEST_LABEL_END;

  return 0;
}
