/**
 *
 * @file resource.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: resource.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef SCTG_RESOURCE_HH
#define SCTG_RESOURCE_HH

#include <systemc>
#include <boost/property_tree/ptree.hpp>
#include <string>
#include <vector>
#include <map>

namespace sctg
{
   class Resource : public sc_core::sc_module
   {
   public:
      
      //* Constructor
      Resource(sc_core::sc_module_name name, 
	       const boost::property_tree::ptree& pt);
      
      //* Destructor
      virtual ~Resource();
      
      //* Returns name
      const std::string& getName() const;
      
      //* Returns ID
      unsigned long int getId() const;
      
      //* Returns operating frequency
      unsigned long int getFrequency() const;
      
      //* Returns type
      const std::string& getType() const;

      //* Returns terminal id
      unsigned long int getTerminal() const;
      
      //* Set terminal's address
      void setTerminal(unsigned long int terminal,
		       unsigned long int address,
		       unsigned long int width);

      //* Get terminal's address
      unsigned long int getTerminalAddress(unsigned long int terminal) const;

      //* Get terminal's width
      unsigned long int getTerminalWidth(unsigned long int terminal) const;
      
   private:
      
      std::string       _name;
      unsigned long int _id;
      unsigned long int _freq;
      std::string       _type;
      //unsigned long int _address;
      
      std::vector<unsigned long int> _terminals;
      std::map<unsigned long int, unsigned long int> _terminalAddress;
      std::map<unsigned long int, unsigned long int> _terminalWidth;
      
   };
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
