/**
 *
 * @file buffer_if.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: buffer_if.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef SCTG_BUFFER_IF_HH
#define SCTG_BUFFER_IF_HH

#include "tg_packet.hh"
#include <systemc>

namespace sctg
{
  class BufferInterface
  {
  public:

    virtual ~BufferInterface() {};

    // NoC to Agent interface

    //* Puts packet to buffer
    // Throws exception if there is not enough space for packet
    virtual void rxPutPacket(tgPacket* packet) = 0;

    //* Returns amount of bytes left in receive buffer
    virtual unsigned long int rxSpaceLeft() = 0;

    //* Returns event which notifies when rx buffer has been read by PE
    virtual sc_core::sc_event* rxGetReadEvent() = 0;
    
    // Agent to NoC interface

    //* True if transmit buffer has packet(s) to send through network
    virtual bool txPacketAvailable() = 0;

    //* Returns packet to be sent
    virtual tgPacket* txGetPacket() = 0;

    //* Returns event that indicates when buffer has packets to send
    virtual sc_core::sc_event* txGetPacketAvailableEvent() = 0;

  };

}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
