/**
 * File:    ServiceActivationInfo.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 28.2.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.data;

import java.util.ArrayList;
import java.util.List;

/**
 * ServiceActivationInfo contains list of services and connections
 * that should be activated and deactivated at the same time.
 */
public class ServiceActivationInfo {
	public static final int SERVICE = -1;
	public static final int CONNECTION = -2;
	private List<Integer> activatedItems = new ArrayList<Integer>(); 

	/**
	 * Creates new ServiceActivationInfo.
	 */
	public ServiceActivationInfo() {
		// do nothing
	}
	
	/**
	 * Add a new item to be activated.
	 * @param type  Type of the item: SERVICE or CONNECTION.
	 * @param id    Id of the item
	 * @param value Activation value of the item
	 */
	public void addActivatedItem(int type, int id, int value) {
		activatedItems.add(new Integer(type));
		activatedItems.add(new Integer(id));
		activatedItems.add(new Integer(value));
	}
	
	/**
	 * @return Returns the amount of items.
	 */
	public int getItemCount() {
		return activatedItems.size()/3;
	}
	
	/**
	 * @return Returns the type of the item in index'th position.
	 */
	public int getItemType(int index) {
		return activatedItems.get(index*3);
	}

	/**
	 * @return Returns the id of the item in index'th position.
	 */
	public int getItemId(int index) {
		return activatedItems.get(index*3+1);
	}
	
	
	/**
	 * @return Returns the value of the item in index'th position.
	 */
	public int getItemValue(int index) {
		return activatedItems.get(index*3+2);
	}
}