/**
 *
 * @file ocp_tl3_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ocp_tl3_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "ocp_tl3_factory.hh"

#include <string>
#include <iostream>
#include <stdexcept>

namespace sctg
{
   namespace mesh_2d_sc_ocp_tl3_1
   {
      
      OcpTl3Factory::OcpTl3Factory(sctg::NocConfIf* nocConfIf)
      {  
	 std::string subtype = nocConfIf->getNocSubType();
	 if(subtype == "2x2")
	 {
	    _adapter_4 = new sctg::SctgToOcpTl3<4, 32>("adapter", nocConfIf);
	    _mesh_2x2  = new OcpTl3Mesh2D<32, 2, 2, 20>("mesh");	    
	    for(unsigned int i = 0; i < 4; ++i)
	    {
	       (_adapter_4->masterSocket)->bind(*(_mesh_2x2->slaveSocket[i]));
	       (_mesh_2x2->masterSocket[i])->bind(*(_adapter_4->slaveSocket));
	    }
	 }
	 else if(subtype == "4x4")
	 {
	    _adapter_16 = new sctg::SctgToOcpTl3<16, 32>("adapter", nocConfIf);
	    _mesh_4x4  = new OcpTl3Mesh2D<32, 4, 4, 20>("mesh");
	    for(unsigned int i = 0; i < 16; ++i)
	    {
	       (_adapter_16->masterSocket)->bind(*(_mesh_4x4->slaveSocket[i]));
	       (_mesh_4x4->masterSocket[i])->bind(*(_adapter_16->slaveSocket));
	    }
	 }
	 else if(subtype == "6x6")
	 {
	    _adapter_36 = new sctg::SctgToOcpTl3<36, 32>("adapter", nocConfIf);
	    _mesh_6x6  = new OcpTl3Mesh2D<32, 6, 6, 20>("mesh");
	    for(unsigned int i = 0; i < 36; ++i)
	    {
	       (_adapter_36->masterSocket)->bind(*(_mesh_6x6->slaveSocket[i]));
	       (_mesh_6x6->masterSocket[i])->bind(*(_adapter_36->slaveSocket));
	    }
	 }
	 else if(subtype == "8x8")
	 {
	    _adapter_64 = new sctg::SctgToOcpTl3<64, 32>("adapter", nocConfIf);
	    _mesh_8x8  = new OcpTl3Mesh2D<32, 8, 8, 20>("mesh");
	    for(unsigned int i = 0; i < 64; ++i)
	    {
	       (_adapter_64->masterSocket)->bind(*(_mesh_8x8->slaveSocket[i]));
	       (_mesh_8x8->masterSocket[i])->bind(*(_adapter_64->slaveSocket));
	    }
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "OcpTl3Factory unknown subtype :\"" << subtype << "\"";
	    throw std::runtime_error(oss.str().c_str());
	 }
      }
      
      OcpTl3Factory::~OcpTl3Factory()
      {
	 std::cout << "OcpTl3Factory destructor" << std::endl;
      }           
   }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

