/**
 *
 * @file crossbar_factory_vhd.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: crossbar_factory_vhd.hh 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */

#ifndef SCTG_VHD_CROSSBAR_FACTORY_HH
#define SCTG_VHD_CROSSBAR_FACTORY_HH


#include "vhd/crossbar_with_pkt_codec_vhd_bfm.hh"
#include "noc_conf_if.hh"

#include <systemc>

namespace sctg
{
   namespace crossbar_vhd
   {

      class CrossbarFactoryVHD
      {
      public:
   
	 CrossbarFactoryVHD(sctg::NocConfIf* nocConfIf);
   
	 virtual ~CrossbarFactoryVHD();      
   
      private:

	 crossbar_with_pkt_codec_vhd_bfm<3, 32, 8>*  xbar3;
	 crossbar_with_pkt_codec_vhd_bfm<4, 32, 8>*  xbar4;
	 crossbar_with_pkt_codec_vhd_bfm<5, 32, 8>*  xbar5;
	 crossbar_with_pkt_codec_vhd_bfm<6, 32, 8>*  xbar6;
	 crossbar_with_pkt_codec_vhd_bfm<7, 32, 8>*  xbar7;
	 crossbar_with_pkt_codec_vhd_bfm<8, 32, 8>*  xbar8;
	 crossbar_with_pkt_codec_vhd_bfm<16, 32, 8>* xbar16;
	 crossbar_with_pkt_codec_vhd_bfm<32, 32, 8>* xbar32;
	 crossbar_with_pkt_codec_vhd_bfm<64, 32, 8>* xbar64;
      };

   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
