/*
 * CVS-tietoja:
 * $Author: jantti2 $ 
 * $Date: 2006-10-27 12:39:15 +0300 (pe, 27 loka 2006) $ 
 * $Revision: 2670 $
 *
 * Created on 19.4.2005
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *
 */
package fi.cpu.serial;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.TooManyListenersException;

import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

import fi.cpu.handler.DataHandler;

/**
 * @author jsikio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class WindowsSerial extends DataHandler implements SerialPortEventListener
{
    
    protected SerialPort serialPort_ = null;
    
    /**
     * @param port
     * @param speed
     * @param useDB
     */
    public WindowsSerial( String port, Integer speed, Boolean useDB )
    {
        super();
        useDB_ = useDB.booleanValue();

        try
        {
            //find the port
            CommPortIdentifier portId = CommPortIdentifier
                    .getPortIdentifier( port );
            //open the port
            serialPort_ = (SerialPort) portId.open( "SerialPort" + port, 2000 );
            //configure the port
            try
            {
                serialPort_.setSerialPortParams( speed.intValue(), SerialPort.DATABITS_8,
                        SerialPort.STOPBITS_1, SerialPort.PARITY_NONE );
            }
            catch ( UnsupportedCommOperationException e )
            {
                System.out.println( "Probably an unsupported Speed" );
            }
            //establish streams for reading and writing to the port
            try
            {
                //Buffered reader
                bufferedReader_ = new BufferedReader( new InputStreamReader(
                        serialPort_.getInputStream() ) );
                byteReader_ = serialPort_.getInputStream();

                //Buffered writer (write Strings etc)
                bufferedWriter_ = new BufferedWriter( new OutputStreamWriter(
                        serialPort_.getOutputStream() ) );
                //OuputStream for writing bytes.
                byteWriter_ = serialPort_.getOutputStream();
            }
            catch ( IOException e )
            {
                System.out.println( "couldn't get streams" );
            }
            try
            {
                serialPort_.addEventListener( this );
                serialPort_.notifyOnDataAvailable( true );
            }
            catch ( TooManyListenersException e )
            {
                System.out.println( "couldn't add listener" );
            }

        }
        catch ( Exception e )
        {
            System.out.println( "Port in Use" );
            e.printStackTrace();
        }
        
        super.start();
    }

    public void serialEvent( SerialPortEvent event )
    {
        //Get event!
        if ( event.getEventType() == SerialPortEvent.DATA_AVAILABLE )
        {
            System.out.println( "Data available" );
            try
            {
                readData();                
            }
            catch ( Exception e )
            {
                e.printStackTrace();
            }
        }

    }

    public void disconnect()
    {
        serialPort_.close();
    }

    /* (non-Javadoc)
     * @see fi.cpu.handler.Handler#reconnect()
     */
    public void reconnect()
    {
        // TODO Auto-generated method stub
        
    }
    
}
