// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: slave.cc,v 1.2 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Slave::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  resp.SData = 0;
  last_request = OCP_MCMD_IDLE;
  bytemask = 0;
  for (int i=0;i<1024;i++)
    memory[i] = 0;
  SC_METHOD(proc);
  sensitive_pos(clk);
  dont_initialize(); // make sure we execute only at clock edge
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Slave::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc()
//
//  Synchronous slave process
//
// ----------------------------------------------------------------------------

void Slave::proc(){

  // If a previous has been served, we check for new requests
  if (last_request == OCP_MCMD_IDLE) {
    is_req = tpP->getOCPRequest(req, true); // accept automatically
    if (is_req) {
      last_request = req.MCmd;
      if (req.MByteEn & 0x1)
	bytemask = 0xFF; 
      if  (req.MByteEn & 0x2)
	bytemask = 0xFF00 | bytemask; 
      if  (req.MByteEn & 0x4)
	bytemask = 0xFF0000 | bytemask; 
      if  (req.MByteEn & 0x8)
	bytemask = 0xFF000000 | bytemask; 
    }
  }

  // If request was write
  if (last_request == OCP_MCMD_WR) {
    memory[req.MAddr/4] = req.MData & bytemask;
#ifdef DEBUG_G1
    cout << "Slave got write request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  data  = " << req.MData << endl;
#endif
    tmp = tpP->getMBusy();
    if (!tmp) {
      // Set OCP response
      resp.SResp = OCP_SRESP_DVA;
      resp.SData = 0;
      // Send response
      tpP->startOCPResponse(resp);
#ifdef DEBUG_G1
      cout << "Slave sent response " << resp.SResp
	   << " time " << sc_time_stamp().to_seconds()
	   << endl;
#endif
      
      last_request = OCP_MCMD_IDLE;
    }
  }
  else if (last_request == OCP_MCMD_RD) {
	
#ifdef DEBUG_G1
    cout << "Slave got read request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  address  = " << req.MAddr << endl;
#endif

    tmp = tpP->getMBusy();
    if (!tmp) {
      // Set OCP response
      resp.SResp = OCP_SRESP_DVA;
      resp.SData = memory[req.MAddr/4];
      // Send response
      tpP->startOCPResponse(resp);
#ifdef DEBUG_G1
      cout << "Slave sent response " << resp.SResp
	   << " time " << sc_time_stamp().to_seconds()
	   << " data " << resp.SData << endl;
#endif
      
      last_request = OCP_MCMD_IDLE;
    }
  } // end if (last_request)
} // end of method



