// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - Layer-1 test Master
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MData = 0;
  req.MAddr = 0;

  SC_THREAD(proc);
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Master<TdataCl>::proc() {
  while(1) {
    // Set OCP command type
    req.MCmd = OCP_MCMD_WR;

    // Send request
    tmp = ipP->startOCPRequestBlocking(req);
    if (tmp) {
	
#ifdef DEBUG_G1
      cout << "Master sent request " << req.MCmd
	   << " time " << sc_time_stamp().to_seconds();
      if (req.MCmd == OCP_MCMD_WR) {
	cout << " data " << req.MData;
	req.MData++;
      }
      cout << endl;
#endif
      
      req.MAddr += 4;
      cnt++;
    }
    else
      wait(); // stop if blocking returns false
  }

} // end of method





// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class Master< OCP_TL1_SIGNAL_CL >;

