// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: master_nb.cc,v 1.1 2005/05/21 00:36:21 anssi Exp $
//
//  Description : OCP API - Layer-1 non-blocking test Master
// ============================================================================

#include "master_nb.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> MasterNb<TdataCl>::MasterNb (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MData = 0;
  req.MAddr = 0;

  SC_THREAD(proc);
  sensitive << clk;
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> MasterNb<TdataCl>::~MasterNb() {}

// ----------------------------------------------------------------------------
//  Method : MasterNb::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void MasterNb<TdataCl>::proc() {
  while(1) {
    // Set OCP command type
    req.MCmd = OCP_MCMD_WR;

    wait();
    // Send request
    tmp = ipP->startOCPRequest(req);
    if (tmp) {
	
#ifdef DEBUG_G1
      cout << "MasterNb sent request " << req.MCmd
	   << " time " << sc_time_stamp().to_seconds();
      if (req.MCmd == OCP_MCMD_WR) {
	cout << " data " << req.MData;
	req.MData++;
      }
      cout << endl;
#endif
      
      req.MAddr += 4;
      cnt++;
    }
  }

} // end of method





// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class MasterNb< OCP_TL1_SIGNAL_CL >;

