// 
// Copyright 2004 OCP-IP
// OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Alan Kamas, for Sonics, Inc.
//              : Yann Bajot, Prosilog
//          $Id:
//
//  Description : OCP TL2 Slave port declaration.
//                These methods are implemented in the Channel
//
// ============================================================================

#ifndef OCP_TL2_SLAVEPORT_H
#define OCP_TL2_SLAVEPORT_H

#include "systemc/communication/sc_event_finder.h"
#include "ocp_tl2_slave_if.h"


template <class Tdata, class Taddr> class OCP_TL2_SlavePort
: public sc_port< OCP_TL2_SlaveIF<Tdata, Taddr> >
{
    public:

        // Constructor
        OCP_TL2_SlavePort(const char* name)
            : sc_port< OCP_TL2_SlaveIF<Tdata, Taddr> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the OCP TL2 Channel using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::RequestEndEvent ); }
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResponseEndEvent ); }

        // Access to the MThreadBusyEvent event of the OCP TL2 Channel using event finders
	sc_event_finder& MThreadBusyEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::MThreadBusyEvent ); }

        // Access to timing variables update event of OCP TL2 Channel using event finders
	sc_event_finder& MasterTimingEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::MasterTimingEvent ); }

        // Reset Events
        sc_event_finder& ResetStartEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResetStartEvent ); }
        sc_event_finder& ResetEndEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResetEndEvent ); }

        // Sideband Events
        sc_event_finder& SidebandMasterEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandMasterEvent ); }
        sc_event_finder& SidebandCoreEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandCoreEvent ); }
        sc_event_finder& SidebandSystemEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandSystemEvent ); }

};
#endif  // OCP_TL2_SLAVEPORT_H

