// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexandrian, Sonics
//         $Id: main_2d.cpp,v 1.1 2007/08/21 02:23:35 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================





// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel.h"

// Include user-defined headers
#include "channel_types.h"

// Include submodules

#include "CPUMaster_2d.h"
#include "Slave_2d.h"

int sc_main(int argc, char* argv[]) {

  CPUMaster ms1("ms1");
  Slave sl1("sl1");

  sc_clock tp_Clk("TestClock", 10, SC_NS,0.5);

  sc_signal< sc_bv< 3 > > tp_MCmd;
  sc_signal<sc_bv<A1Size> > tp_MAddr;
  sc_signal<sc_bv<D1Size> > tp_MData;
  sc_signal<sc_bv<D1Size/8> > tp_MByteEn;
  sc_signal<bool> tp_MRespAccept;
  sc_signal<bool> tp_SCmdAccept;
  sc_signal<sc_bv<2> > tp_SResp;
  sc_signal<sc_bv<D1Size> > tp_SData;

  sc_signal<bool> tp_MReqLast;
  sc_signal<bool> tp_MReqRowLast;
  sc_signal<bool> tp_MBurstSingleReq;
  sc_signal<unsigned int> tp_MBurstLength;
  sc_signal<unsigned int> tp_MBlockHeight;
  sc_signal<unsigned int> tp_MBlockStride;
  sc_signal<bool> tp_SRespLast;
  sc_signal<bool> tp_SRespRowLast;

  ms1.MCmd( tp_MCmd );
  ms1.MAddr( tp_MAddr );
  ms1.MData ( tp_MData );
  ms1.MByteEn( tp_MByteEn );
  ms1.MRespAccept( tp_MRespAccept );
  ms1.SCmdAccept( tp_SCmdAccept );
  ms1.SResp( tp_SResp );
  ms1.SData( tp_SData );

  ms1.MReqLast( tp_MReqLast );
  ms1.MReqRowLast( tp_MReqRowLast );
  ms1.MBurstSingleReq( tp_MBurstSingleReq );
  ms1.MBurstLength( tp_MBurstLength );
  ms1.MBlockHeight( tp_MBlockHeight );
  ms1.MBlockStride( tp_MBlockStride );
  ms1.SRespLast( tp_SRespLast );
  ms1.SRespRowLast( tp_SRespRowLast );

  ms1.Clk( tp_Clk );

  sl1.MCmd( tp_MCmd );
  sl1.MAddr( tp_MAddr );
  sl1.MData ( tp_MData );
  sl1.MByteEn( tp_MByteEn );
  sl1.MRespAccept( tp_MRespAccept );
  sl1.SCmdAccept( tp_SCmdAccept );
  sl1.SResp( tp_SResp );
  sl1.SData( tp_SData );

  sl1.MReqLast( tp_MReqLast );
  sl1.MReqRowLast( tp_MReqRowLast );
  sl1.MBurstSingleReq( tp_MBurstSingleReq );
  sl1.MBurstLength( tp_MBurstLength );
  sl1.MBlockHeight( tp_MBlockHeight );
  sl1.MBlockStride( tp_MBlockStride );
  sl1.SRespLast( tp_SRespLast );
  sl1.SRespRowLast( tp_SRespRowLast );

  sl1.Clk( tp_Clk );


  sc_start(5, SC_MS);
  
  return(0);
}
