// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: slave.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP -  TL1 AMBD profile example
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#define DEBUG_G1

#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"
#include "fifo.h"

class Slave : public sc_module {
public:  

  typedef OCPCHANNELBit32 Td;
  typedef OCPCHANNELBit32 Ta;

  OCP_TL1_SlavePort<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ipP;

  sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP request data group
  OCPDataHSGrp<Td> req_data;

  // OCP response group
  OCPResponseGrp<Td> resp;

  fifo<Td, 8> req_fifo;
  fifo<OCPMCmdType, 8> cmd_fifo;
  fifo<Td, 8> resp_fifo;

  bool is_req, is_data, request;

  Td bytemask;
  Td memory[1024];
  Ta address;
  bool burststart;
  int burstlen;
  bool data_pending;
  OCPMCmdType command;
};

#endif
