// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: StlGrammar.cc,v 1.2 2007/10/08 23:46:44 halexan Exp $

#include "StlParser.h"
#include "StlParserAction.h"
#include <boost/bind.hpp>

using namespace std;
using namespace OcpIp;
////////////////////////////////////////////////////////////////////////////
//
//  Semantic actions
//
////////////////////////////////////////////////////////////////////////////

typedef StlParser::MyTransferCommand::DataType DataType;
template<>
DataType
convertNum<DataType, char const*>( char const* str, char const* end )
{
    // pass hex numbers as a string to BigInt, decimal numbers should be
    // held to numbers < 32 by uint_p and can be handled by convertNum and the
    // mnumeric constructor for BigInt
    if ( end - str > 2 && *str == '0' && *(str+1) == 'x' )
        return DataType( str, end );
    else
        return DataType( convertNum<uint32_t>( str, end ) );
}


template<typename ScannerT>
StlParser::definition<ScannerT>::definition(StlParser const& self)
{
    StlCommandType&            commandType( self.m_commandType );
    StlParser::MyTransferCommand& transfer( self.m_transferCmd );
    StlParser::MyTransferCommand::Request& request( transfer._request() );
    statement_p =
      (
       comment_p( "#" )
       | ( as_lower_d["version"] >>
	   (+(alnum_p|punct_p))[SetVersionProxy( self.m_versionChecked )])
       | ( command_p >> ( ! comment_p( '#' ) ) )
       );

    command_p = (
        // [cycle:]
        ( ! ( uint_p >> ch_p(':') )[setVal( self.m_commandDelay )] ) >>
        (
            transferCommand_p       [setVal( commandType, STL_TRANSFER )]
            | waitCommand_p         [setVal( commandType, STL_WAIT )]
            | signalCommand_p       [setVal( commandType, STL_SIGNAL )]
            | resetCommand_p        [setVal( commandType, STL_RESET )]
            | controlStatusCommand_p[setVal( commandType, STL_CONTROLSTATUS )]
            )
        )
        ;
    
    transferCommand_p = (
        idleCommand_p
        | readCommand_p
        | writeCommand_p
        | breadCommand_p
        | bwriteCommand_p
        )
        ;

    OCPMCmdType& mCmd( request.MCmd );
    idleCommand_p = (
        ( as_lower_d["idle"] [setVal( mCmd, OCP_MCMD_IDLE )]
          [setVal( transfer._idleCycles(), (uint32_t)1 ) ] )
        >> !( uint_p )[setVal( transfer._idleCycles() )] )
        ;

    readCommand_p = (
        ( ! tid_p ) >> ( ! cid_p ) >> ( ! tagid_p ) >> ( ! burst_p )
        >> rdcmd_p[SetCmdProxy( transfer )]
        // [/reqinfo]
        >> ( ! ( ch_p( '/' ) >>
                 ( hdnum_p )[setVal( request.MReqInfo ) ] ) )
        >> as_addr_p
        // [be] number or rbe for random
        >> ( ! ( ch_p( '(' ) >>
                 (  ( hdnum_p[setVal( request.MByteEn )]
                      | as_lower_d["rbe"][setVal( transfer.m_randByteEn, true )]
                     ) ) >> ch_p( ')' ) ) )
//         >> ( ! ( ( expectData_p >> expectDataInfo_p )
//                  | ( longest_d[expectData_p | expectDataInfo_p] ) ) )
        >> ( ! ( expectData_p || expectDataInfo_p ) )
        )
        ;

    writeCommand_p = (
        ( ! tid_p ) >> ( ! cid_p ) >> ( ! tagid_p ) >> ( ! burst_p )
        >> wrcmd_p[SetCmdProxy( transfer )]
        // [/reqinfo]
        >> ( ! ( ch_p( '/' ) >>
                 ( hdnum_p )[setVal( request.MReqInfo ) ] ) )
        >> as_addr_p
        // [be] number or rbe for random
        >> ( ! ( ch_p( '(' ) >>
                 (  ( hdnum_p[setVal( request.MByteEn )]
                      | as_lower_d["rbe"] ) ) >> ch_p( ')' ) ) )
        // data
        >> hdnum_p[setVal( transfer.m_currentData )]
        // [datainfo]
        >> ( ! ( hdnum_p[setVal( transfer.m_currentDataInfo )] ) )
        )
        ;

    breadCommand_p = (
        ( ! tid_p ) >> ( ! cid_p ) >> ( ! tagid_p ) >> ( ! burst_p )       
        >> brdcmd_p[SetCmdProxy( transfer )]
        // [/reqinfo]
        >> ( ! ( ch_p( '/' ) >>
                 ( hdnum_p )[setVal( request.MReqInfo ) ] ) )
        >> as_addr_p )[BurstMacroProxy( transfer )]
        ;

    bwriteCommand_p = (
        ( ! tid_p ) >> ( ! cid_p ) >> ( ! tagid_p ) >> ( ! burst_p )
        >> bwrcmd_p[SetCmdProxy( transfer )]
        // [/reqinfo]
        >> ( ! ( ch_p( '/' ) >>
                 ( hdnum_p )[setVal( request.MReqInfo ) ] ) )
        >> as_addr_p
        >> dataSpec_p 
        >> ( ! ( ch_p( '/' ) >> dataInfoSpec_p ) )
        )[BurstMacroProxy( transfer )]
        ;

    // note shortest overlapping pattern last (readex before read)
    rdcmd_p    = lexeme_d[
        (
            (   as_lower_d["readex"] | as_lower_d["rdex"] )
            | ( as_lower_d["readlinked"] | as_lower_d["rdl"]  )
            | ( as_lower_d["read"] | as_lower_d["rd"]   )
            )  
            >> ( ! ( ch_p( '8' ) | str_p( "16" ) | str_p( "32" ) | str_p( "64" )
                     | str_p( "128" ) | str_p( "256" ) ) ) ]
        ;

    brdcmd_p   =
        ( as_lower_d["bread"] | as_lower_d["brd"] )
        ;
    
    wrcmd_p   = lexeme_d[
        (
            (   as_lower_d["writenonpost"] | as_lower_d["wrnp"] )
            | ( as_lower_d["writeconditional"] | as_lower_d["wrc"]  )
            | ( as_lower_d["write"] | as_lower_d["wr"]   )
            | ( as_lower_d["broadcast"] | as_lower_d["bcst"] )
            )  
            >> ( ! ( ch_p( '8' ) | str_p( "16" ) | str_p( "32" ) | str_p( "64" )
                     | str_p( "128" ) | str_p( "256" ) ) ) ]
        ;

    bwrcmd_p   =
        ( as_lower_d["bwritenonpost"] | as_lower_d["bwrnp"] )
        | ( as_lower_d["bwrite"] | as_lower_d["bwr"] )
        | ( as_lower_d["bbroadcast"] | as_lower_d["bbcst"] )
        ;
    
    // Notice the trick of using / in the as rule to avoid the addrspace
    // semantic action taking place because of excessive greed. The trick is
    // that the / will get ignored by strtoX
    as_addr_p  = (
        ( ! ( ( hdnum_p >>
                ch_p( '/' ) )[setVal( request.MAddrSpace ) ] ) )
        >> ( ( hdnum_p )[setVal( request.MAddr ) ] ) )
        ;

    dataSpec_p = (
        ( as_lower_d["ndata"][setVal( transfer.m_currentDataSpec,
                                      StlParser::MyTransferCommand::NDATA )] )
        // rdata [seed]
        | ( ( as_lower_d["rdata"] >> ( ! ( uint_p[&StlParser::setRandomSeed] ) )
              [setVal( transfer.m_currentDataSpec,
                       StlParser::MyTransferCommand::RDATA )] ) )
        // cdata value
        | ( ( as_lower_d["cdata"] >> hdnum_p[setVal( transfer.m_currentData )]
              [setVal( transfer.m_currentDataSpec,
                       StlParser::MyTransferCommand::CDATA )] ) )
        | ( as_lower_d["adata"][setVal( transfer.m_currentDataSpec,
                                        StlParser::MyTransferCommand::ADATA )] )
        )
        ;

    expectData_p = (
        hdnum_p >> ( ! ( ch_p( '(' ) >> hdnum_p >> ch_p( ')' ) ) )
        >> ( ~epsilon_p( '/' ) )
        )
        [setVal( transfer.m_currentDataMask, self.s_fullOneData )]
        [setPair( transfer.m_currentData, transfer.m_currentDataMask, "()" )]
        ;

    expectDataInfo_p = (
        hdnum_p >> ( ! ( ch_p( '/' ) >> hdnum_p ) )
        )
        [setVal( transfer.m_currentDataInfoMask,
                 static_cast<snx_uint64_t>(-1) )]
        [setPair( transfer.m_currentDataInfo,
                  transfer.m_currentDataInfoMask, "/" )]
        ;
        
    dataInfoSpec_p = (
        ( as_lower_d["ndi"][setVal( transfer.m_currentDataInfoSpec,
                                    StlParser::MyTransferCommand::NDI )] )
        // rdata [seed]
        | ( ( as_lower_d["rdi"] >> ( ! ( uint_p[&StlParser::setRandomSeed] ) )
              [setVal( transfer.m_currentDataInfoSpec,
                       StlParser::MyTransferCommand::RDI )] ) )
        // cdata value
        | ( ( as_lower_d["cdi"] >> hdnum_p[setVal( transfer.m_currentDataInfo )]
              [setVal( transfer.m_currentDataInfoSpec,
                       StlParser::MyTransferCommand::CDI )] ) )
        )
        ;

    tid_p = (
        hdnum_p[setVal( request.MThreadID ) ]
        )
        ;

    cid_p = (
        ( ch_p( '/' ) >> ( hdnum_p )[setVal( request.MConnID ) ] )
        )
        ;

    tagid_p = (
        ( as_lower_d["t="] >> ( hdnum_p )[setVal( request.MTagID ) ] )
        )
        ;

    uint32_t&     mBurstLength( request.MBurstLength );
    uint32_t&     mBlockHeight( request.MBlockHeight );
    uint32_t&     mBlockStride( request.MBlockStride );
    bool&         mBurstPrecise( request.MBurstPrecise );
    bool&         mBurstSRMD( request.MBurstSingleReq );

    // [ <length>, <height>, <stride> ]
    burstblock_p = ( ch_p( '[' )
                     >> hdnum_p [setVal( mBurstLength )] >> ch_p( ',' )
                     >> hdnum_p [setVal( mBlockHeight )] >> ch_p( ',' )
                     >> hdnum_p [setVal( mBlockStride )]
                     >> ch_p( ']' ) );
        
    burst_p = ( ch_p( '(' )
                >> ( uint_p[setVal( mBurstLength )] | burstblock_p )
                >> !( ch_p( ',' ) >> burstseq_p ) )
                >> !( ch_p( ',' ) >>
                      ( ( as_lower_d["prec"]
                          [setVal( mBurstPrecise, true )]
                          [setVal( mBurstSRMD, false )] ) |
                        ( as_lower_d["imprec"]
                          [setVal( mBurstPrecise, false )]
                          [setVal( mBurstSRMD, false )] ) |
                        ( as_lower_d["srmd"][setVal( mBurstSRMD, true )] ) ) )
                >> !( ch_p( ',' ) >> uint_p ) // MAtomicLength
                >> ch_p( ')' )     
        ;

    OCPMBurstSeqType& mBurstSeq( request.MBurstSeq );
    // note shortest overlapping pattern last (readex before read)
    burstseq_p   =
        ( (     as_lower_d["incr" ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_INCR )]
          |   ( as_lower_d["dflt1"] )[setVal( mBurstSeq, OCP_MBURSTSEQ_DFLT1 )]
          |   ( as_lower_d["wrap" ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_WRAP )]
          |   ( as_lower_d["dflt2"] )[setVal( mBurstSeq, OCP_MBURSTSEQ_DFLT2 )]
          |   ( as_lower_d["xor"  ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_XOR )]
          |   ( as_lower_d["strm" ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_STRM )]
          |   ( as_lower_d["blck" ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_BLCK )]
          |   ( as_lower_d["unkn" ] )[setVal( mBurstSeq, OCP_MBURSTSEQ_UNKN )] )
        ;

    // shortcut references
    StlParserWaitCommand& wait( self.m_waitCmd );
    StlWaitCommand::Waiter& tmpWaiter( wait.m_tmpWaiter );
    SignalName& waitSignal( tmpWaiter.m_signal );

    waitCommand_p   = (
        as_lower_d["wait"]
        >> ( ! ( as_lower_d["and"] | as_lower_d["or"] ) )
        [boost::bind(&StlParserWaitCommand::setAndOr, &wait, _1, _2)]
        >> ( +(
            // response: consider argument always positive. (eat the -)
            (  as_lower_d["response"][setVal( tmpWaiter.m_response, true )] >>
               ( ! ( ch_p('=') >> ( !ch_p('-') ) >>
                     uint_p[setVal( tmpWaiter.m_value )] ) ) )
            // flags|threadbusy=value[(mask)]
            | ( ( as_lower_d["threadbusy"][setVal( waitSignal, S_SThreadBusy )]
                  | as_lower_d["flags"][setVal( waitSignal, S_SFlag )]
                  | as_lower_d["tbflags"][setVal( tmpWaiter.m_tbflags, true )] )
                >> ch_p('=') >> hdnum_p[setVal( tmpWaiter.m_value )]
                >> ( ! ( ch_p('(') >> ( hdnum_p )[setVal( tmpWaiter.m_mask )]
                         >> ch_p(')' ) ) ) )
            // single bit signals
            | ( ( as_lower_d["interrupt"][setVal( waitSignal, S_SInterrupt )]
                  | as_lower_d["error"][setVal( waitSignal, S_SError )]
                  | as_lower_d["controlwr"][setVal( waitSignal, S_ControlWr )]
                  | as_lower_d["statusrd"][setVal( waitSignal, S_StatusRd )]
                  | as_lower_d["controlbusy"][setVal( waitSignal, S_ControlBusy )]
                  | as_lower_d["statusbusy"][setVal( waitSignal, S_StatusBusy )] )
                >> ch_p('=')
                >> (limit_d(0,1)[int_p])[setVal( tmpWaiter.m_value )] ) )
             [boost::bind( &deque<StlWaitCommand::Waiter>::push_back,
                           &( wait._waiters() ), boost::ref( tmpWaiter ) )]
             [boost::bind( &StlWaitCommand::Waiter::clear, &tmpWaiter )] )
        )
        ;

    StlParserSignalCommand& signal( self.m_signalCmd );
    signalCommand_p = (
        as_lower_d["signal"]
        >> ( ( ( as_lower_d["flags"][setVal( signal._signal(), S_MFlag )] 
                 | as_lower_d["tbflags"][setVal( signal._tbflags(), true )] )
               >> ( ! ( ( ch_p('=') >> hdnum_p[setVal( signal._value() )] ) )
                    >> ( ! ( ch_p('(') >> hdnum_p[setVal( signal._mask() )]
                             >> ch_p(')') ) ) ) )
             | ( as_lower_d["error"][setVal( signal._signal(), S_MError )]
                 >> ch_p('=') >> hdnum_p[setVal( signal._value() )] )
             | ( as_lower_d["controlbusy"][setVal( signal._signal(),
                                                   S_ControlBusy )]
                 >> ch_p('=') >> (limit_d(0,1)[int_p])[setVal( signal._value() )] )
             | ( as_lower_d["statusbusy"][setVal( signal._signal(),
                                                  S_StatusBusy )]
                 >> ch_p('=') >> (limit_d(0,1)[int_p])[setVal( signal._value() )] ) )
        )
        ;

    resetCommand_p =
        ( as_lower_d["reset"] >> uint_p
          [setVal( self.m_resetCmd._resetCycles() )] )
        ;

    const bool control = false;
    const bool status  = true;
    const bool read    = false;
    const bool write   = true;
    StlParserControlStatusCommand& cs( self.m_controlStatusCmd );
    controlStatusCommand_p = (        
        ( ( ( as_lower_d["writecontrol"][setVal( cs._controlStatus(), control )]
              | as_lower_d["writestatus"][setVal( cs._controlStatus(), status )] )
            [setVal( cs._readWrite(), write )] )
          >> hdnum_p[setVal( cs._value() )] )
        |
        ( ( ( as_lower_d["readcontrol"][setVal( cs._controlStatus(), control )]
              | as_lower_d["readstatus"][setVal( cs._controlStatus(), status )] )
            [setVal( cs._readWrite(), read )] )
          >> ( ! ( hdnum_p[setVal( cs._value() )]
                   [setVal( cs._mask(), static_cast<snx_uint64_t>(-1) )] ) ) )
        )
        ;

    // number possibly hex
    hdnum_p = ( lexeme_d[ as_lower_d["0x"] >> ( +( range_p('a','f') |
                                                   range_p('A','F') |
                                                   digit_p ) ) ] ) | uint_p;

}

template class StlParser::definition<phrase_scanner_t>;

