// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: main.cc,v 1.4 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API -  TL1 profile example
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel_clocked.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master_w.h"
#include "master_r.h"
#include "slave.h"

#include "ocp_tl1_trace_monitor.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap1, ocpParamMap2;
  string ocpParamFileName1, ocpParamFileName2;

  sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName1, ocpParamFileName2);

  // Read OCP parameters from file
  if ( ! ocpParamFileName1.empty() ) {
    readMapFromFile(ocpParamFileName1, ocpParamMap1);
  }
  if ( ! ocpParamFileName2.empty() ) {
    readMapFromFile(ocpParamFileName2, ocpParamMap2);
  }

  // OCP channel declaration. Allows clocked blocking calls, and OCP trace monitor (if installed)
  typedef  OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> data_type;
  typedef  OCP_TL1_Channel_Clocked< data_type > channel_type;
  channel_type ch0("ocp0");
  OCP_TL1_Trace_Monitor< data_type > mon0("mon0", "ocp0.ocp");
  mon0.p_mon(ch0);
  mon0.p_clk(clk);

  channel_type ch1("ocp1");
  OCP_TL1_Trace_Monitor< data_type > mon1("mon1", "ocp1.ocp");
  mon1.p_mon(ch0);
  mon1.p_clk(clk);

  // Submodules
  Slave sl1("sl1");
  Master_w ms1("ms1");
  Master_r ms2("ms2");

  // Set OCP configuration
  ch0.setConfiguration(ocpParamMap1);
  ch1.setConfiguration(ocpParamMap2);

  // netlist
  ch0.p_clk(clk);
  ch1.p_clk(clk);

  ms1.ipP(ch0);
  ms1.clk(clk);

  ms2.ipP(ch1);
  ms2.clk(clk);
  
  sl1.wP(ch0);
  sl1.rP(ch1);
  sl1.clk(clk);

  // Simulator
  sc_start(50000, SC_NS);
  
  return(0);
}
