// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: OcpBundleDefs.h,v 1.1 2007/01/25 22:09:07 halexan Exp $
#ifndef _OcpIp_OcpBundleDefs_h
#define _OcpIp_OcpBundleDefs_h

#include "NamedIndex.h"

namespace ocpip_legacy {
namespace OcpIp {
#define OCPPARAMETER(name, def) P_##name,
    enum ParamName {
#include "ocp.parameters"
    };
#undef OCPPARAMETER

#define OCPSIGNAL(name, ARGS...) S_##name,
#define OCPSIGNAL_COMPLEX(name, ARGS...) S_##name,
    enum SignalName {
#include "ocp.signals"
    };
#undef OCPSIGNAL
#undef OCPSIGNAL_COMPLEX

    namespace Definitions {
    enum Endian {
        ENDIAN_NEUTRAL = 0,
        ENDIAN_LITTLE  = 1,
        ENDIAN_BIG     = 2,
        ENDIAN_BOTH    = 3
    };
    enum Interface{ MASTER, SLAVE, MONITOR };
    enum Model{ CORE, SYSTEM };
    }
}
}
 
template<>
NamedIndex<ocpip_legacy::OcpIp::ParamName>::NamedIndex();
template<>
NamedIndex<ocpip_legacy::OcpIp::SignalName>::NamedIndex();

#endif /* _OcpIp_OcpBundleDefs_h_ */
