///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  This file contains an sc_core::sc_signal-like structure, that allows
//                 for delta delayed value changes or immediate value changes.
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#ifndef OCPIP_VERSION
  #error ocp_tl1_monitor_signal.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION{

template <class T>
class ocp_tl1_monitor_signal{
public:
  ocp_tl1_monitor_signal(const T& initVal);
  
  inline void setDelayed(const T& val) const;
  
  inline bool alreadySetDelayed() const;
  
  inline void setDirect(const T& val);
  
  inline T& get() const;
  
private:
  mutable T oldVal, newVal;
  mutable sc_core::sc_time lastTime;
};


}

#include __MACRO_STRINGYFY__(../mon/src/OCPIP_VERSION/ocp_tl1_monitor_signal.tpp)
