// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author :Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : TL3 simple example system 
//		  using delayed interfaces with implicit timing annotation
//
// ============================================================================


#include "ocp_tl3_master.h"
#include "ocp_tl3_slave.h"
#include "ocp_tl3_bus.h"

#include "ocp_tl3_channel.h"

// OCP monitor package is installed
#ifdef PERF_MONITOR
#include "ocp_tl3_perf_monitor.h"
#endif

// SCV package is installed
#ifdef SCV
#include "scv.h"
#endif

int sc_main(int, char*[])
{

#ifdef SCV
  scv_tr_text_init();
  scv_tr_db db("ocp_db");
  scv_tr_db::set_default_db(&db);
#endif

  int end_time = 50000;

  typedef unsigned int Ta;
  typedef unsigned int Td;
  typedef basic_protocol::basic_request<Td,Ta> requestType;
  typedef basic_protocol::basic_response<Td>   responseType;
  typedef OCP_TL3_Channel<requestType,responseType>  channelType;
  channelType  ch_m0("ch_m0");
  channelType  ch_s0("ch_s0");
  channelType  ch_s1("ch_s1");

#ifdef PERF_MONITOR
  typedef OCP_TL3_Perf_Monitor<requestType,responseType> monitorType;
  monitorType mon_m0("mon_m0");
  monitorType mon_s0("mon_s0");
  monitorType mon_s1("mon_s1");
  mon_m0.p_mon(ch_m0);
  mon_s0.p_mon(ch_s0);
  mon_s1.p_mon(ch_s1);
#endif

  // Creates masters and slaves 
  ocp_tl3_master<Ta,Td> ms0("ms0");
  ocp_tl3_slave <Ta,Td> sl0("sl0");
  ocp_tl3_slave <Ta,Td> sl1("sl1");
  ocp_tl3_bus<Ta,Td> bus("bus",1,2);

  // Connect masters and slaves using channels
  ms0.ocp(ch_m0.master_export);

  bus.ocp_s(ch_m0.slave_export);
  bus.ocp_m(ch_s0.master_export);
  bus.ocp_m(ch_s1.master_export);
    
  sl0.ocp_req(ch_s0.slave_export);
  sl0.ocp_resp(ch_s0.slave_export);
  sl1.ocp_req(ch_s1.slave_export);
  sl1.ocp_resp(ch_s1.slave_export);

  static float fSimulationCPUTime = 0;
  clock();

  // start simulation 
  sc_start(end_time, SC_NS);

  fSimulationCPUTime = (float)( (float)clock() / (float)CLOCKS_PER_SEC );
  cerr << "SystemC simulated duration: " << sc_time_stamp() << endl;
  cerr << "                  CPU time: " << fSimulationCPUTime <<  endl;

  return (0);
};
