// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stphane Guntz, PROSILOG, guntz@prosilog.com
//         Date : 03/10/2003
//
//  Description : Transaction Level - Layer-0 to Layer-1 Slave Adapter
//
// ============================================================================

#ifndef _OCP_TL0_TL1_TARGET_ADAPTER_H
#define _OCP_TL0_TL1_TARGET_ADAPTER_H

#include "ocp_tl1_globals.h"
#include "tl_slave_port.h"

template <class TdataCl> class OCP_TL0_TL1_Slave_Adapter
  : public sc_module
  , public SdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // TL1 Slave Port
  tl_slave_port<TdataCl> SlaveP;

  // TL0 Basic OCP Master ports
  sc_in_clk             Clk;
  sc_out<sc_bv<3> > 	MCmd;
  sc_out<Ta>          	MAddr;
  sc_out<Td>          	MData;
  sc_in<bool>   	    SCmdAccept;
  sc_in<Td>           	SData;
  sc_in<sc_bv<2> >      SResp;
  sc_out<bool>  	    MRespAccept;

  SC_HAS_PROCESS(OCP_TL0_TL1_Slave_Adapter);

  // Default constructor: no need to specify explicit sampling times, use default ones
  OCP_TL0_TL1_Slave_Adapter(sc_module_name name_
             , int ID
             , bool Combinational
             , sc_time ClockCycle
             , bool Check_setup_time = true
            );

  // Constructor with explicit sampling timings
  OCP_TL0_TL1_Slave_Adapter(sc_module_name name_
             , int ID                   
             , sc_time CmdAcceptSampleDelay = sc_get_time_resolution() 
             , sc_time ResponseSampleDelay = sc_get_time_resolution() 
             , bool Check_setup_time = true    
            );


  // destructor
  ~OCP_TL0_TL1_Slave_Adapter();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);
  void send_Response();
  void set_MRespAccept();
  void reset_TL0_signals();
  void send_Request();
  void release_Request();
  void sample_events_trigger();
  void check_cmdaccept_setup_time();
  void check_response_setup_time();

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  sc_event e_response_sample_event;
  sc_event e_cmdaccept_sample_event;
  int m_ID;
  double m_DelayPct;
  sc_time m_cmdaccept_sample_delay;
  sc_time m_response_sample_delay;
  bool m_check_active;
  sc_time m_last_rising_edge;
  bool m_default_values;
};


#endif // _OCP_TL0_TL1_TARGET_ADAPTER_H
