// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : definition of simple OCP TL2 slave,
//		  SCV based randomization of transactions and timing,
//		  implicit delay annotation of OCP_TL3_MasterDelayedIF
//
// ============================================================================

#ifndef _OCP_TL3_SLAVE_CPP
#define _OCP_TL3_SLAVE_CPP

#include "ocp_tl3_slave.h"

template <class Td, class Ta>
ocp_tl3_slave<Td,Ta>::ocp_tl3_slave(sc_module_name mod):
  sc_module(mod), 
  ocp_req("ReqP"),
  ocp_resp("RespP"),
  m_req_count_ocp(0),
  m_resp_count_ocp(0)
{
  m_sptr_resp_delay = 10;
  m_sptr_req_accept = 7;

  SC_METHOD(get_request_method);
  sensitive << ocp_req.RequestStartEvent();
  dont_initialize();
}

template <class Td, class Ta>
ocp_tl3_slave<Td,Ta>::~ocp_tl3_slave()
{
  cout << name() << ", received : " << m_req_count_ocp 
       << ", sent : " << m_resp_count_ocp << endl;
}

template <class Td, class Ta>
void
ocp_tl3_slave<Td,Ta>::end_of_elaboration()
{
}

template <class Td, class Ta>
void
ocp_tl3_slave<Td,Ta>::get_request_method()
{
  requestType req;

  if (!ocp_req->getRequest(req)) {
    cerr << sc_time_stamp() << " slave " << name() 
	 << " nothing to get " << endl;
    ocp_req->acceptRequest();
    return;
  } 
  m_req_count_ocp++;
#ifdef DEBUG_TL3_SLAVE 
  cout << sc_time_stamp() << " slave " << name() 
       << " got request :" << endl << req << endl;
#endif
  m_sptr_req_accept = 5+ (m_sptr_req_accept+1)%8;
  m_sptr_resp_delay = 5+ (m_sptr_req_accept+1)%10;
  switch (req.type) {
  case basic_protocol::READ:
    // First, create a response to store the outgoing data

#ifdef DEBUG_TL3_SLAVE 
    cout << sc_time_stamp() << " slave " << name() 
	 << " send response in " << m_sptr_resp_delay
	 << " cycles\n";
#endif
    // handle response delay
    ocp_resp->sendResponse( m_resp,m_sptr_resp_delay );
    // increment response counter
    m_resp_count_ocp++;
    ocp_req->acceptRequest(m_sptr_req_accept + m_sptr_resp_delay);
    break;
  default:
    ocp_req->acceptRequest(m_sptr_req_accept);
    break;
  }
}

#endif // _OCP_TL3_SLAVE_CPP
