// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//
//          $Id:
//
//  Description : OCP TL3 Monitor Observer Interface
//
// ============================================================================

#ifndef _OCP_TL3_MONITOR_OBSERVER_IF
#define _OCP_TL3_MONITOR_OBSERVER_IF

template <class, class> class OCP_TL3_MonitorPeekIF;

template 
< typename REQ, 
  typename RESP
>
class OCP_TL3_Monitor_ObserverIF
{
public:
  typedef OCP_TL3_MonitorPeekIF<REQ,RESP> tl3_peek_type;

  virtual ~OCP_TL3_Monitor_ObserverIF() {};

  virtual void registerChannel(tl3_peek_type *, 
			       bool master_is_node = false,
			       bool slave_is_node = false)	= 0;

  virtual void NotifyRequestStart(tl3_peek_type *)		= 0;
  virtual void NotifyRequestEnd(tl3_peek_type *)		= 0;
  virtual void NotifyResponseStart(tl3_peek_type *)		= 0;
  virtual void NotifyResponseEnd(tl3_peek_type *)		= 0;

};

#endif // _OCP_TL3_MONITOR_OBSERVER_IF
