module rfe(
 vagc, 
 vsup, 
 gnda, 
 rfein, 
 rfeout, 
 lo 
);

input	vagc;
input	vsup;
input	gnda;
input	rfein;
output  rfeout;
input	lo;

wire  vagc;
wire  vsup;
wire  gnda;
wire  rfein;
wire  rfeout;
wire  lo;

wire i_lna_out_sig;
wire i_mixer_out_sig;

lna #(
      .lna_gain (1.0) 
      ) 
i_lna (
      .vcc(     vsup          ),
      .vagc(    vagc          ),
      .gnda(    gnda          ),
      .in(      rfein         ),
      .out(     i_lna_out_sig ) 
      );


mixer #(
      .mix_gain (1.0) 
      ) 
i_mixer (
      .vcc(      vsup            ),
      .gnda(     gnda            ),
      .in(       i_lna_out_sig   ),
      .out(      i_mixer_out_sig ),
      .lo_in(    lo              ) 
      );


filter #(
      .fc (1000),
      .h0 (1.0) 
      ) 
i_filt (
      .vcc(     vsup            ),
      .gnda(    gnda            ),
      .in(      i_mixer_out_sig ),
      .out(     rfeout  ) 
      );

endmodule
